"use client";
import React, { Fragment, useState } from "react";
import useMediaQuery from "@mui/material/useMediaQuery";

//css
import styles from "@/assets/css/category/MainCategory.module.css";
//css

import Skeleton from "@mui/material/Skeleton";
import Pagination from "../category/Pagination";
import ViewListIcon from '@mui/icons-material/ViewList';
import ViewModuleIcon from '@mui/icons-material/ViewModule';
import ToggleButtonIcon from '@mui/material/ToggleButton';
import ToggleButtonGroup from '@mui/material/ToggleButtonGroup';
import SubCategory from "../category/SubCategory";
import Filters from "../menu/mobile/Filters";
import dynamic from "next/dynamic";
import ProductCard from '../ProductCard'
import CardContainer from "../constantElements/CardContainer";

const Filter = dynamic(() => import("@/components/constantElements/Filter"), {
    ssr: false,
    loading: () => (
        <div className="w-[150px] h-[45px] sm:col-span-1">
            <Skeleton
                variant="rectangular"
                sx={{ width: "100%" }}
                height={45}
                animation="wave"
            />
        </div>
    ),
});

const SideBar = dynamic(() => import("@/components/category/SideBar"), {
    ssr: false,
    loading: () => (
        <div className="col-span-2 xl:block hidden w-full h-screen">
            <Skeleton
                variant="rectangular"
                sx={{ width: "100%" }}
                height={628}
                animation="wave"
            />
        </div>
    ),
});

const Card = dynamic(() => import("@/components/Card"), {
    ssr: false,
    loading: () => (
        <div className="w-auto h-[447.19px] p-2 mb-2">
            <Skeleton
                variant="rounded"
                sx={{ width: "auto" }}
                height={447.19}
                animation="wave"
            />
        </div>
    ),
});



const overRide = () => ({
    display: "block",
    margin: "0 auto",
});


const Package = ({ apiData = null, pages, scrollTo , testValue }) => {

    const [filters, setFilters] = useState(false)
    const tablet = useMediaQuery("(max-width:1280px)");
    const [list, setList] = useState(false)
    const [view, setView] = useState(`module`);
    const mobile = useMediaQuery("(max-width : 540px)");
    const handleChange = (event, nextView) => {
        if (nextView !== null) setView(nextView);
        setList(nextView == 'list' ? true : false)
    };
    const [filterData, setFilterData] = useState(null)


    const data = (data) => {
        if (apiData.products.total == data.data.products.total) {
            setFilterData(null);
        } else {
            setFilterData(data)
        }

    }





    return (
        <>
            <main className={`flex flex-col items-center ${styles.mainContainer}`}>

                <>
                    <section
                        className={`grid grid-flow-row grid-cols-9 sm:px-4 px-2 py-8 gap-4 w-full  max-with-unique`}
                    >
                        <SideBar
                            className="col-span-2 xl:block hidden"
                            type='brand'
                            sideBanner={apiData.side_banners}
                            filters={apiData.filters}
                            popularData={apiData.popular_sliders}
                            sendData={data}
                            scrollTo={scrollTo}
                            testValue={testValue}
                            id={"all"}
                        />

                        {/* Aside Of Category */}
                        <section className="xl:col-span-7 col-span-9">
                            {
                                apiData &&
                                apiData.packege_categories.length > 0 &&
                                <section className="grid xl:grid-cols-5 md:grid-cols-4 grid-cols-2 gap-4 mb-12">
                                    {apiData.packege_categories.map(subCategory => (
                                        <Fragment key={subCategory.id}>
                                            <SubCategory
                                                slug={`packages/${subCategory.slug}`}
                                                name={subCategory.name}
                                                type='package'
                                            />
                                        </Fragment>
                                    ))}

                                </section>
                            }
                            {/* cards */}
                            <CardContainer
                                apiData={apiData}
                                pages={pages}
                                scrollTo={scrollTo}
                                // currentSlug={currentSlug}
                                type="package"
                            />



                            {apiData.products.last_page != 1
                                &&
                                <Pagination
                                    pagel={scrollTo}
                                    currentPage={pages}
                                    pages={apiData.products.last_page}
                                    links={apiData.products.links}
                                    slug={apiData.products.slug}
                                />
                            }

                        </section>

                    </section>
                </>

            </main>
        </>
    );
};

export default Package;