"use client";
import React, { useEffect, useState } from "react";
import styles from "../assets/css/ProductCard.module.css";
import LocalOfferIcon from "@mui/icons-material/LocalOffer";
import TimerCustom from "@/components/constantElements/TimerCustom";
import ImageCustom from "./constantElements/ImageCustom";
import Image from "next/image";
import noImage from "../../public/images/no-image.png";
import Link from "next/link";
import RocketLaunchIcon from "@mui/icons-material/RocketLaunch";
import PhoneIcon from "@mui/icons-material/Phone";
import NotificationsIcon from "@mui/icons-material/Notifications";
import CancelIcon from "@mui/icons-material/Cancel";
import InventoryIcon from "@mui/icons-material/Inventory";
import { useMediaQuery } from "@mui/material";
import Skeleton from "@mui/material/Skeleton";

let date = new Date();

const ProductCard = ({
  data = null,
  styleList,
  styleListMobile,
  width = null,
  height = null,
}) => {
  
  const miniMobile = useMediaQuery("(max-width:375px)");
  const mobile = useMediaQuery("(max-width:600px)");
  const portraitTablets = useMediaQuery(
    "(min-width:600px)  and (max-width:768px) "
  );
  const landscapeTablets = useMediaQuery(
    "(min-width:768px) and (max-width:992px)"
  );
  const laptops = useMediaQuery("(min-width:992px) and (max-width:1200px)");
  const [showVideo, setShowVideo] = useState(false);
  const [client, setClient] = useState(false);

  function responsive(purpose) {
    if (purpose == "width") {
      if (miniMobile) {
        return 162;
      } else if (mobile) {
        return 275;
      } else if (portraitTablets) {
        return 259;
      } else if (landscapeTablets) {
        return 196;
      } else if (laptops) {
        return 270;
      } else {
        return 207;
      }
    } else if (purpose == "height") {
      if (miniMobile) {
        return 162;
      } else if (mobile) {
        return 275;
      } else if (portraitTablets) {
        return 259;
      } else if (landscapeTablets) {
        return 196;
      } else if (laptops) {
        return 270;
      } else {
        return 207;
      }
    }
  }

  function responsivePriceList(purpose) {
    if (purpose == "width") {
      if (miniMobile) {
        return 162;
      } else if (mobile) {
        return 275;
      } else if (portraitTablets) {
        return 259;
      } else if (landscapeTablets) {
        return 196;
      } else if (laptops) {
        return 270;
      } else {
        return 207;
      }
    } else if (purpose == "height") {
      if (miniMobile) {
        return 162;
      } else if (mobile) {
        return 275;
      } else if (portraitTablets) {
        return 259;
      } else if (landscapeTablets) {
        return 196;
      } else if (laptops) {
        return 270;
      } else {
        return 207;
      }
    }
  }

  useEffect(() => {
    setClient(true);
  }, []);

  return (
    <Link
      href={data.slug ? `/${data.slug}` : "#"}
      title={data.alt_name}
      className={styleListMobile == "module" ? styles.card_mobile : styles.card}
    >
      {/* card head */}
      <div className="h-6 flex justify-between items-center">
        <div>
          {data.new_product == 1 && <div className="text-[#DE1616]">جدید</div>}
        </div>
        {data.marketable == 0 ? (
          data.discount &&
          !Array.isArray(data.discount) &&
          date < new Date(data.discount.end_date) ? (
            <>
              {data.discount.infinite_status == 1 ? (
                <div className="flex items-center justify-end">
                  <div className="tracking-widest text-[#DE1616] sm:text-sm text-xs font-medium">
                    پیشنهاد ویژه
                  </div>
                {
                  client &&
                  <LocalOfferIcon
                    sx={{ color: "#DE1616", ml: 0.5 }}
                    fontSize="medium"
                  />
                }
                </div>
              ) : (
                client &&
                <TimerCustom
                  startDate={data.discount.start_date}
                  endDate={data.discount.end_date}
                />
              )}
            </>
          ) : null
        ) : null}
      </div>

      {/* card head */}

      <div
        className={
          styleList == "list"
            ? styles.card_content_list
            : styleListMobile == "module"
            ? styles.card_content_mobile
            : styles.card_content
        }
      >
        <div className="body">
          {/* card image */}
          {data.image ? (
            <div
              className="mb-2 relative overflow-hidden"
              onMouseEnter={() => setShowVideo(true)}
              onMouseLeave={() => setShowVideo(false)}
            >
              {showVideo && (
                <>
                  {data.video ? (
                    <div className="w-full h-full absolute top-0 bg-black z-10">
                      <video
                        width="1900"
                        height="500"
                        controls={false}
                        className="w-full h-full"
                        autoPlay
                        muted
                      >
                        <source src={data.video} type="video/mp4" />
                      </video>
                    </div>
                  ) : null}
                </>
              )}
              {
              
              (data.batch && !Array.isArray(data.batch))
              &&
                <div 
                className="absolute bottom-0 text-xs left-0 py-2 px-4"
                style={{
                  color:data.batch.text_color , 
                  backgroundColor : data.batch.bg_color,
                  borderRadius :'16px 0 16px 0'
                }}
                >
                  {data.batch.name}
                </div>
              
              }
              <ImageCustom
                data={data.image}
                alt={data.image_alt}
                title={data.image_alt}
                // props
                loading={"eager"}
                fullWidth={false}
                className="block product_image"
                style={{ margin: "0 auto" }}
                height={height ? height : responsive("height")}
                width={width ? width : responsive("width")}
              />
            </div>
          ) : (
            <Image src={noImage} alt="عکس پیشفرض" className="mb-4" />
          )}
          <div className="h-4 sm:hidden flex gap-2">
            {data.colors
              ? data.colors.length > 1 &&
                data.colors.map((color) => (
                  <div
                    key={color.id}
                    className="w-4 h-4 border rounded-sm"
                    style={{ backgroundColor: color.color_code }}
                  ></div>
                ))
              : null}
          </div>
        </div>

        <div
          className={`grid  ${
            styleList == "list"
              ? "col-span-5 grid-cols-5 gap-2 items-center"
              : "col-span-1 grid-cols-1 gap-4"
          }`}
        >
          <div
            className={
              styleList == "list"
                ? styles.card_details_list
                : styles.card_details
            }
          >
            {/* card feature */}
            <div
              className={
                styleList == "list"
                  ? "flex gap-4 h-11"
                  : "grid grid-cols-4 h-11"
              }
            >
              {data.attributes &&
                data.attributes.length > 0 &&
                data.attributes.map((attribute) => (
                  <div
                    key={attribute.id}
                    className="grid gap-[1px] place-items-center"
                  >
                    <ImageCustom
                      data={attribute.icon}
                      alt={attribute.icon_alt}
                      title={attribute.icon_alt}
                      // props
                      size={"original"}
                      width={15}
                      height={15}
                      fullWidth={false}
                    />
                    <div className="text-[10px] text-center text-[#333333] font-medium">
                      {attribute.attribute_value}
                    </div>
                  </div>
                ))}
            </div>
            {/* card feature */}

            <div
              className={`
              ${styleList == "list" ? "flex-col gap-4" : "items-center gap-2"}
               sm:flex justify-between hidden`}
            >
              <div className="flex items-center gap-2 h-4">
                {data.colors
                  ? data.colors.length > 1 &&
                    data.colors.map((color) => (
                      <div
                        key={color.id}
                        className="w-4 h-4 border rounded-sm"
                        style={{ backgroundColor: color.color_code }}
                      ></div>
                    ))
                  : null}
              </div>

              <div className="h-7">
                {data.shipper && !Array.isArray(data.shipper) && (
                  <div className="flex items-center w-fit bg-[#009688] px-2 py-1 rounded-lg">
                    {
                      client &&
                    <RocketLaunchIcon
                      fontSize="small"
                      sx={{ mr: 0.5, color: "#fff" }}
                    />
                    }
                    <div className="text-sm text-white">ارسال سریع</div>
                  </div>
                )}
              </div>
            </div>

            {/* shipper */}
            <div className="h-7 sm:hidden block">
              {data.shipper && !Array.isArray(data.shipper) && (
                <div className="flex items-center w-fit bg-[#009688] px-2 py-1 rounded-lg">
                  {
                      client &&
                    <RocketLaunchIcon
                      fontSize="small"
                      sx={{ mr: 0.5, color: "#fff" }}
                    />
                    }
                  <div className="text-sm text-white">ارسال سریع</div>
                </div>
              )}
            </div>

            {/* shipper */}

            {/* card name */}
            <div
              className={`sm:text-sm text-xs min-h-[40px] leading-5 ${styles.truncate}`}
            >
              {data.name}
            </div>
            {/* card name */}
          </div>

          {/* card footer */}
          {data.type != 1 ? (
            <>
              {data.marketable == 0 && data.price != 0 ? (
                <>
                  {data.discount &&
                  !Array.isArray(data.discount) &&
                  date < new Date(data.discount.end_date) ? (
                    <div
                      className={` ${
                        styleList == "list"
                          ? "h-full flex flex-col items-end justify-center"
                          : "h-12"
                      }`}
                    >
                      <div
                        className={`flex items-center ${
                          styleList == "list"
                            ? "justify-end gap-4"
                            : "justify-between gap-2"
                        } items-center`}
                      >
                        {data.discount.type == 0 ? (
                          <div className="sm:text-sm text-xs bg-[#DE1616] px-1 text-white rounded-md">{`${data.discount.percentage} %`}</div>
                        ) : (
                          <div className="sm:text-sm text-xs bg-[#DE1616] px-1 text-white rounded-md">{`${Number(
                            Math.round(
                              (data.discount.percentage / data.price) * 100
                            )
                          )} %`}</div>
                        )}
                        <div className="flex justify-end">
                          <span className="text-[#DE1616] sm:text-base text-sm">
                            {data.discount.type == 0 ? (
                              <span className="font-semibold tracking-widest">{`${Number(
                                data.discount.final_price
                              ).toLocaleString()}`}</span>
                            ) : (
                              <span className="font-bold tracking-widest">{`${Number(
                                data.discount.final_price
                              ).toLocaleString()}`}</span>
                            )}
                            <span className="text-xs mr-1">تومان</span>
                          </span>
                        </div>
                      </div>
                      <div className="flex justify-end sm:text-sm text-xs text-[#C4C3C3] line-through">
                        <span>
                          <span className="font-bold tracking-widest">{`${Number(
                            data.price
                          ).toLocaleString()}`}</span>
                          <span className="text-xs mr-1">تومان</span>
                        </span>
                      </div>
                    </div>
                  ) : (
                    <div className="flex justify-end h-12 items-center">
                      <span>
                        <span className="font-bold tracking-widest">{`${Number(
                          data.price
                        ).toLocaleString()}`}</span>
                        <span className="text-xs mr-1">تومان</span>
                      </span>
                    </div>
                  )}
                </>
              ) : data.marketable == 1 ? (
                <div
                  className={`flex ${
                    styleListMobile == "list"
                      ? "justify-end gap-4"
                      : "justify-between"
                  } items-center h-12`}
                >
                  <div className="text-[#009688] font-bold">تماس بگیرید</div>
                  {
                    client &&
                  <PhoneIcon fontSize="medium" sx={{ color: "#009688" }} />
                  }
                </div>
              ) : data.marketable == 2  ? (
                <div
                  className={`flex ${
                    styleListMobile == "list"
                      ? "justify-end gap-4"
                      : "justify-between"
                  } items-center h-12`}
                >
                  <div className="text-[#555555] font-bold">ناموجود</div>
                  {client &&
                  
                  <NotificationsIcon
                    fontSize="medium"
                    sx={{ color: "#555555" }}
                  />
                  }
                </div>
              ) : data.marketable == 3 ? (
                <div
                  className={`flex ${
                    styleListMobile == "list"
                      ? "justify-end gap-4"
                      : "justify-between"
                  } items-center h-12`}
                >
                  <div className="text-[#555555] font-bold">توقف تولید</div>
                  {client &&
                  
                  <CancelIcon fontSize="medium" sx={{ color: "#555555" }} />
                  }
                </div>
              ) : null}
            </>
          ) : data.price ? (
            <>
              {data.discount &&
              !Array.isArray(data.discount) &&
              date < new Date(data.discount.end_date) ? (
                <div className={` ${
                  styleList == "list"
                    ? "h-full flex flex-col items-end justify-center"
                    : "h-12"
                }`}>
                  <div
                    className={`flex items-center ${
                      styleListMobile == "list"
                        ? "justify-end gap-4"
                        : "justify-between gap-2"
                    }`}
                  >
                    {data.discount.type == 0 ? (
                      <div className="sm:text-sm text-xs bg-[#DE1616] px-1 text-white rounded-md">{`${data.discount.percentage} %`}</div>
                    ) : (
                      <div className="sm:text-sm text-xs bg-[#DE1616] px-1 text-white rounded-md">{`${Number(
                        Math.round(
                          (data.discount.percentage / data.price) * 100
                        )
                      )} %`}</div>
                    )}
                    <div className="flex justify-end">
                      <span className="text-[#DE1616] sm:text-base text-sm">
                        {data.discount.type == 0 ? (
                          <span className="font-semibold tracking-widest">{`${Number(
                            data.discount.final_price
                          ).toLocaleString()}`}</span>
                        ) : (
                          <span className="font-bold tracking-widest">{`${Number(
                            data.discount.final_price
                          ).toLocaleString()}`}</span>
                        )}
                        <span className="text-xs mr-1">تومان</span>
                      </span>
                    </div>
                  </div>
                  <div className="flex justify-end text-sm text-[#C4C3C3] line-through">
                    <span>
                      <span className="font-bold tracking-widest">{`${Number(
                        data.price
                      ).toLocaleString()}`}</span>
                      <span className="text-xs mr-1">تومان</span>
                    </span>
                  </div>
                </div>
              ) : (
                <div className="flex justify-end h-12 items-center">
                  <span>
                    <span className="font-bold tracking-widest">{`${Number(
                      data.price
                    ).toLocaleString()}`}</span>
                    <span className="text-xs mr-1">تومان</span>
                  </span>
                </div>
              )}
            </>
          ) : (
            <div className="flex justify-between items-center h-12">
              <div className="text-[#DE1616] lg:text-base text-sm font-bold">
                مشاهده همه پکیج ها
              </div>
              {client &&
              
              <InventoryIcon fontSize="medium" sx={{ color: "#DE1616" }} />
              }
            </div>
          )}
          {/* card footer */}
        </div>
      </div>
    </Link>
  )
};

export default ProductCard;
