"use server";
import Layout from "@/components/Layout";
import MainSlider from "../components/main/MainSlider";
import dynamic from "next/dynamic";
import styles from "../assets/css/main/Main.module.css";
import SpecialCategory from "../components/main/SpecialCategory";
import Title from "@/components/main/Title";
import Discount from "@/components/main/Discount";
import BrandsCarousel from "@/components/constantElements/BrandsCarousel";
import CardsCarousel from "@/components/constantElements/CardsCarousel";
import BannerCustom from "@/components/constantElements/BannerCustom";
import Skeleton from "@mui/material/Skeleton";
import SelectedCategories from "@/components/SelectedCategories";
import AboutUs from "@/components/constantElements/AboutUs";
// import BannerCarousel from '@/components/constantElements/BannerCarousel'
import QuickAccess from "@/layouts/QuickAccess";
import { Fragment } from "react";
import '@/styles/styles.css'
// import Blog from '../components/main/Blog'

const CardContainerDynamic = dynamic(
  () => import("../components/main/CardContainer"),
  { ssr: false }
);

const BannerCarousel = dynamic(
  () => import("@/components/constantElements/BannerCarousel"),
  {
    ssr: false,
    loading: () => (
      <div className="w-full mb-12 mt-2 sm:h-[330px] h-[187px]">
        <Skeleton
          variant="rectangular"
          sx={{ width: "100%" }}
          className="sm:h-[330px] h-[187px]"
          animation="wave"
        />
      </div>
    ),
  }
);

const backendUrl = process.env.NEXT_PUBLIC_BACKEND_URL;
const frontendUrl = process.env.NEXT_PUBLIC_FRONTEND_URL;

let date = new Date();
export default async function Home() {
  const data = await fetch(`${backendUrl}/api/home`, {
    cache: "no-store",
    headers: { "domain-name": frontendUrl },
  });
  const home = await data.json();
  // console.log(home);

  return (
    <>
      <Layout>
        <main className={`${styles.container}`}>
          {home.controlls.map((homeData, i) => {
            switch (homeData.content_type) {
              case "partBanner":
                return (
                  <Fragment key={homeData.id}>
                  {
                  homeData.name_status == 1 &&
                  <Title titleValue={homeData.name} />
                  }
                  
                    <BannerCarousel
                    data={homeData}
                    navigation={true}
                    className="mb-12 mt-2"
                    borderRadius="8px"
                    />
                  </Fragment>
                );
              case "fullWidthBanner":
                return (
                  
                  homeData && (
                    <Fragment key={homeData.id}>
                  {
                  homeData.name_status == 1 &&
                  <Title titleValue={homeData.name} />
                  }
                    <BannerCarousel
                      key={i}
                      data={homeData.full_width_banner}
                      navigation={true}
                      className="mb-12 mt-2"
                      borderRadius="0"
                    />
                    </Fragment>
                  )
                );
              case "simpleBanner":
                return (
                  homeData.banners && (
                    <Fragment key={homeData.id}>
                  {
                  homeData.name_status == 1 &&
                  <Title titleValue={homeData.name} />
                  }
                    <section
                      key={i}
                      className="grid grid-cols-2 sm:gap-4 gap-2 grid-rows-[repeat(2, minmax(0, max-content))] mb-16 max-with-unique mx-auto sm:px-4 px-2"
                    >
                      {homeData.banners.map((banner, index) => (
                        <BannerCustom
                          key={banner.id}
                          data={banner}
                          className="last:odd:col-span-2"
                          status={
                            homeData.banners.length == 1
                              ? "odd"
                              : homeData.banners.length % 2 == 0
                              ? "even"
                              : index == homeData.banners.length - 1
                              ? "odd"
                              : "even"
                          }
                        />
                      ))}
                    </section>
                    </Fragment>
                  )
                );
              case "simpleCategory":
                return (
                  <Fragment key={homeData.id}>
                  {
                  homeData.name_status == 1 &&
                  <Title titleValue={homeData.name} />
                  }
                  <SelectedCategories
                    key={i}
                    type="topPage"
                    simpleCategory={homeData.simple_category}
                  />
                  </Fragment>
                );
              case "fantasticCategory":
                return (
                  homeData.fantastic_category && (
                  
                    <SelectedCategories
                      key={i}
                      type={"middlePage"}
                      title = {homeData.name_status == 1 ? homeData.name : null}
                      simpleCategory={homeData.fantastic_category}
                    />
                  )
                );
              case "amazingSellBox":
                return date <
                  new Date(homeData.discount_sliders[0].discount.end_date) ? (
                  <Discount
                    key={i}
                    productDiscountSlider={homeData.discount_sliders}
                  />
                ) : null;
              case "simpleProduct":
                return (
                  homeData.product_normal_sliders && (
                    
                    <section className={`h-auto mb-16`} key={i}>
                      <Title titleValue={homeData.name} />
                      <CardContainerDynamic
                        type="observations"
                        productNormalSliders={homeData.product_normal_sliders}
                      />
                    </section>
                  )
                );
              case "specialProduct":
                return (
                  homeData.special_product_content && (
                    <section key={i} className="mb-16">
                      <CardContainerDynamic
                        type="bestSellers"
                        title={homeData.name}
                        backgroundColor={homeData.background_color}
                        productGroupSliders={homeData.special_product_content}
                      />
                    </section>
                  )
                );

              case "groupProduct":
                return (
                  <CardsCarousel
                    key={i}
                    data={homeData.group_product}
                    slidesPerView={5}
                    className="mb-4"
                    type="group_slider"
                  />
                );

              case "brandProductContent":
                return (
                  homeData.brand_Product_content && (
                    <section
                      key={i}
                      className="h-fit flex flex-col items-center mb-4"
                    >
                      <Title titleValue={homeData.name} />
                      <CardContainerDynamic
                        backgroundColor={homeData.background_color}
                        productNormalSliders={
                          homeData.brand_Product_content.products
                        }
                        slug={homeData.link}
                        titleValue={homeData.name}
                      />
                      <BrandsCarousel
                        slidesPerView={5}
                        data={homeData.brand_Product_content.brands}
                      />
                    </section>
                  )
                );

              case "accordContent":
                return (
                  homeData.accord_content && (
                    <SpecialCategory
                      key={i}
                      title={homeData.name}
                      contentBox={homeData.accord_content}
                    />
                  )
                );
              case "content":
                return (
                  homeData.body && (
                    <>
                      <section
                        className=" rounded-lg content-first-page"
                        style={{
                          maxWidth: "1358px",
                          margin: "1rem auto",
                          backgroundColor: "#f7f7f7",
                          padding: "1rem 1.5rem",
                        }}
                      >
                        {homeData.name_status == 1 && (
                          <h2 className="my-4 sm:text-2xl text-lg">
                            {homeData.name}
                          </h2>
                        )}
                        <div
                          dangerouslySetInnerHTML={{ __html: homeData.body }}
                          className="text-justify text-[#747272]"
                        />
                      </section>
                    </>
                  )
                );
              default:
                break;
            }
          })}

          {/* <QuickAccessDynamic /> */}
          {/* <MainSlider /> */}

          {/* new products */}
          {home.new_products.length > 0 ? (
            <CardsCarousel
              data={home.new_products}
              slidesPerView={5}
              spaceBetween={5}
              className="mb-4"
              title={["محصولات جدید"]}
              backgroundColor="#fff"
              link="مشاهده بیشتر"
              slug="/new-products"
            />
          ) : null}
          {/* new products */}

          {/* <Blog /> */}

          <AboutUs />
        </main>
      </Layout>
      <QuickAccess />
    </>
  );
}
