"use client";
import React, { useEffect, useRef, useState } from "react";
import ButtonCustom from "../constantElements/ButtonCustom";
import ImageCustom from "../constantElements/ImageCustom";
import useMediaQuery from "@mui/material/useMediaQuery";
import Link from "next/link";
import PictureAsPdfIcon from "@mui/icons-material/PictureAsPdf";
//context
const backendUrl = process.env.NEXT_PUBLIC_BACKEND_URL_IMAGE;
const ProductSpecifications = ({
  attributes,
  attributeImage,
  alt,
  files = [],
  fileName,
}) => {
  const mobile = useMediaQuery("(max-width:540px)");
  const specificationScroll = useRef();
  const [showMore, setShowMore] = useState(false);
  const [client, setClient] = useState(false);

  useEffect(() => {
    setClient(true);
  }, []);

  return (
    <div
      className={`mb-10 scroll-mt-32 mt-12`}
      ref={specificationScroll}
      id="property"
    >
      <div className="flex justify-between items-center mb-2 border-b">
        <p className="font-bold mb-2">مشخصات محصول</p>
      </div>
      <div
        className={`py-2 w-full sm:grid sm:grid-cols-2 sm:grid-flow-row-dense sm:gap-4 flex flex-col-reverse place-items-center`}
      >
        <div
          className={`w-full h-fit grid grid-cols-1 sm:gap-4 gap-2 sm:mt-0 mt-5`}
        >
          {attributes
            .slice(0, showMore ? attributes.length : mobile ? 1 : 3)
            .map((value) => {
              return (
                <div
                  key={value.id}
                  className="grid sm:grid-cols-5 grid-cols-1 gap-2"
                >
                  <div className="sm:text-base text-xs">
                    {value.attribute_parent_name}
                  </div>
                  <div className="grid  gap-2 sm:col-span-4">
                    {value.childrens.map((child) => (
                      <dl
                        key={child.id}
                        className="grid grid-cols-2 sm:gap-4 gap-2"
                      >
                        <dt className="bg-stone-300 p-2 rounded-r-xl sm:text-sm text-xs">
                          {child.attribute_name}
                        </dt>
                        <dd className="bg-stone-200 p-2 rounded-l-xl sm:text-sm text-xs">
                          {child.attribute_value}
                        </dd>
                      </dl>
                    ))}
                  </div>
                </div>
              );
            })}
          {mobile
            ? attributes.length > 1 && (
                <ButtonCustom
                  text={`مشاهده ${showMore ? "کمتر" : "بیشتر"}`}
                  title={`مشاهده ${showMore ? "کمتر" : "بیشتر"}`}
                  variant="text"
                  onClick={() => setShowMore(!showMore)}
                />
              )
            : attributes.length > 3 && (
                <ButtonCustom
                  text={`مشاهده ${showMore ? "کمتر" : "بیشتر"}`}
                  title={`مشاهده ${showMore ? "کمتر" : "بیشتر"}`}
                  variant="text"
                  onClick={() => setShowMore(!showMore)}
                />
              )}
        </div>
        <div>
          {!mobile && (
            <ImageCustom
              data={attributeImage}
              alt={alt}
              title={alt}
              // props
              loading={"lazy"}
              height={410}
              width={410}
              fullWidth={false}
              size="large"
            />
          )}
          {files &&
            files.length > 0 &&
            (client ? (
              <div className="grid grid-cols-1 gap-2 mt-4">
                {files.map((item) => (
                  <a
                    className="p-2 bg-[#009688] text-white rounded-lg text-sm flex items-center gap-2"
                    key={item.id}
                    download
                    title={item.file_name}
                    href={`${backendUrl}${item.file_path}`}
                  >
                    <PictureAsPdfIcon />
                    <span>{item.file_name}</span>
                  </a>
                ))}
              </div>
            ) : null)}
        </div>
      </div>
    </div>
  );
};

export default ProductSpecifications;
