import "@/styles/globals.css";
import { MuiRtlProvider } from "@/context/muiRtlContext";
import { getGlobalPageMetadata } from "@/data/loaders";
import SnakebarContextProvider from "@/context/snakebar";
import MainModalContextProvider from "@/context/modal/mainModal";

import ResetApiContext from "@/context/ResetApiContext";
import Setting from "@/context/api/Setting";

const backendUrl = process.env.NEXT_PUBLIC_BACKEND_URL;
const frontendUrl = process.env.NEXT_PUBLIC_FRONTEND_URL;

const metaData = await getGlobalPageMetadata("api/home/header", { cache: false });


export const viewport = {
  themeColor: metaData.data.data.theme_color,
  width: "device-width",
  initialScale: 1.0,
};

export async function generateMetadata() {
  const backendUrl = process.env.NEXT_PUBLIC_BACKEND_URL;
  return {
    title: metaData.data.data.title,
    description: metaData.data.data.description,
    keywords: metaData.data.data.keywords,
    openGraph: {
      title: metaData.data.data.title,
      description: metaData.data.data.description,
      keywords: metaData.data.data.keywords,
      locale: metaData.data.data.site_lang,
      type: "website",
      siteName: metaData.data.data.title,
      url: metaData.data.data.generator,
    },
    icons: {
      icon:  `${backendUrl}/public/${metaData.data.data.web_app.indexArray.original}`,
      shortcut: `${backendUrl}/public/${metaData.data.data.web_app.indexArray.samll}`,
      apple: `${backendUrl}/public/${metaData.data.data.web_app.indexArray.samll}`,
      other: [
        {
          rel: 'preconnect',
          url: backendUrl,
        },
      ],
    },
    authors: { name: metaData.data.data.author },
    generator: metaData.data.data.generator,

    robots: {
      index: true,
      follow: true,
    },

  };
}

export default async function RootLayout({ children }) {
  const data = await fetch(`${backendUrl}/api/home/header`, {
    cache: "no-store",
    headers: { "domain-name": frontendUrl },
  });
  const metaData = await data.json();
  return (
    <>
      <html lang={"fa"} dir="rtl">
      <head>
      <style>
              {
                `
                :root {
                --theme-color: ${metaData.data.main_color};
                  --theme-color-green: ${metaData.data.second_color};
                  --theme-color-footer: ${metaData.data.footer_color ?? '#72777A'};
                  }
                `
              }
            </style>
      </head>
        <body>
          <ResetApiContext>
            <Setting>
              <MuiRtlProvider>
                <SnakebarContextProvider>
                  <MainModalContextProvider>
                    {children}
                  </MainModalContextProvider>
                </SnakebarContextProvider>
              </MuiRtlProvider>
            </Setting>
          </ResetApiContext>
        </body>
      </html>
    </>
  );
}
