
import DashboardAside from "@/components/dashboard/DashboardAside";
import OrderDetails from "@/components/modals/OrderDetails";
import OrderDetailProvider from "@/context/dashboard/OrderDetailContext";
import Layout from "@/components/Layout";
import styles from "@/assets/css/dashboard/Dashboard.module.css";

export const metadata = {
  title: " سفارش های شما",
  robots: "noindex",
};
const OrderLayout = ({ children }) => {
  return (
    <Layout>
      <main className={styles.container}>
        <DashboardAside />
        <OrderDetailProvider>
          <div className="sm:col-span-4 col-span-5 rounded-lg border overflow-hidden">
            {children}
          </div>
          <OrderDetails />
        </OrderDetailProvider>
      </main>
    </Layout>
  );
};

export default OrderLayout;
