'use client'
import axios from '@/lib/axios';
import React, { createContext, useContext, useEffect, useState } from 'react';
import { ResetApi } from "@/context/ResetApiContext";



export const SettingApi = createContext()

const Setting = ({ children }) => {
  const { reset } = useContext(ResetApi)

  const [dataSetting, setDataSetting] = useState(null);
  const [dataUser, setDataUser] = useState(null);
  const [trigger , setTrigger] = useState(true);
  const [basket , setBasket] = useState(null);
  
  useEffect(() => {
    const getSetting = async () => {
      try {
        const fetchedSetting = await axios.get("api/boot-setting-api", {cache:"no-store"});
        setDataSetting(fetchedSetting);
      } catch (error) { }
    };


    getSetting();
  }, []);


  useEffect(() => {
    axios.get('api/user').then((result) => {
      setDataUser(result);
    }).catch((err) => {
      setDataUser(null)
    });
  }, [reset]);

  useEffect(()=>{
    axios.get("api/basket").then((result) => {
      setBasket(result.data.data);
      
    }).catch((err) => {
      setBasket(null)
    });
  } , [trigger])



  return (
    <SettingApi.Provider value={{ dataSetting, dataUser , setTrigger , basket , trigger }}>
      {children}
    </SettingApi.Provider>
  );
};

export default Setting;