"use client";
import React, { Fragment, useEffect, useState, useRef } from "react";
import dynamic from "next/dynamic";
import Skeleton from "@mui/material/Skeleton";
import Filters from "../menu/mobile/Filters";
import ButtonCustom from "./ButtonCustom";
import { IconButton, useMediaQuery } from "@mui/material";
import styles from "@/assets/css/CardContainer.module.css";
import Card from "@/components/Card";
import Pagination from "../category/Pagination";
import CardsCustom from "./CardsCustom";
import ProductCard from "../ProductCard";

const Filter = dynamic(() => import("@/components/constantElements/Filter"), {
  ssr: false,
  loading: () => (
    <div className="w-[150px] h-[45px] sm:col-span-1">
      <Skeleton
        variant="rectangular"
        sx={{ width: "100%" }}
        height={45}
        animation="wave"
      />
    </div>
  ),
});

const ToggleButtonIconDynamic = dynamic(
  () => import("@mui/material/ToggleButton"),
  { ssr: false }
);

const ToggleButtonGroup = dynamic(
  () => import("@mui/material/ToggleButtonGroup"),
  {
    ssr: false,
    loading: () => (
      <div className={`w-28 h-12 animate-pulse`}>
        <div className={`w-full h-full bg-gray-100 rounded-lg`}></div>
      </div>
    ),
  }
);

const ViewModuleIconDynamic = dynamic(
  () => import("@mui/icons-material/ViewModule"),
  { ssr: false }
);

const ViewListIconDynamic = dynamic(
  () => import("@mui/icons-material/ViewList"),
  { ssr: false }
);

export default function CardContainer({
  apiData,
  pages,
  scrollTo,
  currentSlug,
  type,
  testValue
}) {
  const tablet = useMediaQuery("(max-width:1280px)");
  const mobile = useMediaQuery("(max-width:600px)");
  const [filters, setFilters] = useState(false);
  const [list, setList] = useState(false);
  const [client, setClient] = useState(false);
  const [changeShow, setChangeShow] = useState("module");
  const [changeShowMobile, setChangeShowMobile] = useState("list");

  useEffect(() => {
    setClient(true);
  }, []);

  const handleChange = (event, nextView) => {
    if (nextView !== null) {
      setList(nextView == "list" ? true : false);
      setChangeShow(nextView);
    }
  };
  const handleChangeMobile = (event, nextView) => {
    if (nextView !== null) {
      setChangeShowMobile(nextView);
    }
  };

  return (
    <section id="products">
      {type == "package" ? (
        <>
          {/* filters */}
          <div
            className={`filters flex sm:flex-row flex-row-reverse sm:justify-start justify-between mb-5 h-11 gap-4`}
          >
            {!mobile ? (
              apiData.products &&
              apiData.products.data &&
              apiData.products.data.length > 0 && (
                <Filter
                  type="product"
                  id="all"
                  manufacturer={true}
                  // urlValue={urlValue.length > 0 && urlValue}
                  scrollTo={scrollTo}
                />
              )
            ) : (
              <></>
            )}
            {apiData.products &&
            !Array.isArray(apiData.products) &&
            apiData.products.data &&
            apiData.products.data.length > 0 ? (
              !mobile ? (
                <ToggleButtonGroup
                  orientation="horizontal"
                  value={changeShow}
                  exclusive
                  onChange={handleChange}
                >
                  <ToggleButtonIconDynamic
                    size="small"
                    value="module"
                    aria-label="module"
                  >
                    <ViewModuleIconDynamic />
                  </ToggleButtonIconDynamic>
                  <ToggleButtonIconDynamic
                    size="small"
                    value="list"
                    aria-label="list"
                  >
                    <ViewListIconDynamic />
                  </ToggleButtonIconDynamic>
                </ToggleButtonGroup>
              ) : (
                <ToggleButtonGroup
                  orientation="horizontal"
                  value={changeShowMobile}
                  exclusive
                  onChange={handleChangeMobile}
                >
                  <ToggleButtonIconDynamic
                    size="small"
                    value="module"
                    aria-label="module"
                  >
                    <ViewModuleIconDynamic />
                  </ToggleButtonIconDynamic>
                  <ToggleButtonIconDynamic
                    size="small"
                    value="list"
                    aria-label="list"
                  >
                    <ViewListIconDynamic />
                  </ToggleButtonIconDynamic>
                </ToggleButtonGroup>
              )
            ) : null}
            {tablet &&
              apiData.products &&
              apiData.products.data &&
              apiData.products.data.length > 0 && (
                <>
                  <Filters
                  testValue={testValue}
                    openMenu={filters}
                    onClose={() => setFilters(false)}
                    data={apiData.filters}
                    id={"all"}
                    // sendData={data}
                    // urlValue={urlValue}
                    scrollTo={scrollTo}
                    // currentSlug={currentSlug}
                    manufacturer={true}
                    type="brand"
                  />
                </>
              )}
          </div>
          {/* filters */}

          {/* card place */}
          <div
            className={
              changeShowMobile == "module"
                ? styles.module_mobile
                : changeShow == "module"
                ? styles.module
                : styles.list
            }
          >
            {apiData.products ? (
              !Array.isArray(apiData.products) &&
              apiData.products.data &&
              apiData.products.data.length >= 1 ? (
                apiData.products.data.map((product, index) => {
                  return (
                    product && (
                      <Fragment key={product.id}>
                        <ProductCard
                          data={product}
                          styleList={changeShow}
                          styleListMobile={changeShowMobile}
                        />
                       

                        {product.structure_status == 1 && (
                          <script
                            type="application/ld+json"
                            dangerouslySetInnerHTML={{
                              __html: JSON.stringify(product.data_structure),
                            }}
                          />
                        )}
                      </Fragment>
                    )
                  );
                })
              ) : (
                <p className="w-full p-4 text-center font-bold col-span-4">
                  محصولی برای نمایش موجود نیست
                </p>
              )
            ) : (
              <p className="w-full p-4 text-center font-bold col-span-4">
                محصولی برای نمایش موجود نیست
              </p>
            )}
          </div>
          {/* card place */}
        </>
      ) : type == "packageItem" ? (
        <>
          {/* filters */}
          <div
            className={`filters flex sm:flex-row flex-row-reverse sm:justify-start justify-between mb-5 h-11`}
          >
            {!mobile ? (
              apiData.products &&
              apiData.products.data &&
              apiData.products.data.length > 0 && (
                <Filter
                  type="product"
                  id="all"
                  manufacturer={true}
                  // urlValue={urlValue.length > 0 && urlValue}
                  scrollTo={scrollTo}
                />
              )
            ) : (
              <></>
            )}
            {apiData.products &&
            !Array.isArray(apiData.products) &&
            apiData.products.data &&
            apiData.products.data.length > 0 ? (
              !mobile ? (
                <ToggleButtonGroup
                  orientation="horizontal"
                  value={changeShow}
                  exclusive
                  onChange={handleChange}
                >
                  <ToggleButtonIconDynamic
                    size="small"
                    value="module"
                    aria-label="module"
                  >
                    <ViewModuleIconDynamic />
                  </ToggleButtonIconDynamic>
                  <ToggleButtonIconDynamic
                    size="small"
                    value="list"
                    aria-label="list"
                  >
                    <ViewListIconDynamic />
                  </ToggleButtonIconDynamic>
                </ToggleButtonGroup>
              ) : (
                <ToggleButtonGroup
                  orientation="horizontal"
                  value={changeShowMobile}
                  exclusive
                  onChange={handleChangeMobile}
                >
                  <ToggleButtonIconDynamic
                    size="small"
                    value="module"
                    aria-label="module"
                  >
                    <ViewModuleIconDynamic />
                  </ToggleButtonIconDynamic>
                  <ToggleButtonIconDynamic
                    size="small"
                    value="list"
                    aria-label="list"
                  >
                    <ViewListIconDynamic />
                  </ToggleButtonIconDynamic>
                </ToggleButtonGroup>
              )
            ) : null}
            {tablet &&
              apiData.products &&
              apiData.products.data &&
              apiData.products.data.length > 0 && (
                <>
                  <Filters
                  testValue={testValue}
                    openMenu={filters}
                    onClose={() => setFilters(false)}
                    data={apiData.filters}
                    id={"all"}
                    // sendData={data}
                    // urlValue={urlValue}
                    scrollTo={scrollTo}
                    // currentSlug={currentSlug}
                    manufacturer={true}
                    type="brand"
                  />
                </>
              )}
          </div>
          {/* filters */}

          {/* card place */}
          <div
            className={
              changeShowMobile == "module"
                ? styles.module_mobile
                : changeShow == "module"
                ? styles.module
                : styles.list
            }
          >
            {apiData.products ? (
              !Array.isArray(apiData.products) &&
              apiData.products.data &&
              apiData.products.data.length >= 1 ? (
                apiData.products.data.map((product, index) => {
                  return (
                    product && (
                      <Fragment key={product.id}>
                        <ProductCard
                          data={product}
                          styleList={changeShow}
                          styleListMobile={changeShowMobile}
                        />
                        

                        {product.structure_status == 1 && (
                          <script
                            type="application/ld+json"
                            dangerouslySetInnerHTML={{
                              __html: JSON.stringify(product.data_structure),
                            }}
                          />
                        )}
                      </Fragment>
                    )
                  );
                })
              ) : (
                <p className="w-full p-4 text-center font-bold col-span-4">
                  محصولی برای نمایش موجود نیست
                </p>
              )
            ) : (
              <p className="w-full p-4 text-center font-bold col-span-4">
                محصولی برای نمایش موجود نیست
              </p>
            )}
          </div>
          {/* card place */}

          {/* pagination */}
          {apiData.products &&
          !Array.isArray(apiData.products) &&
          apiData.products.data &&
          apiData.products.last_page != 1 ? (
            <Pagination
              pagel={scrollTo}
              currentPage={pages}
              pages={apiData.products.last_page}
              links={apiData.products.links}
              slug={apiData.products.slug}
            />
          ) : null}
          {/* pagination */}
        </>
      ) : type == "brand" ? (
        <>
          {/* filters */}
          <div
            className={`filters flex sm:flex-row flex-row-reverse sm:justify-start justify-between mb-5 h-11`}
          >
            {apiData.products &&
            !Array.isArray(apiData.products) &&
            apiData.products.data &&
            apiData.products.data.length > 0 ? (
              !mobile ? (
                <ToggleButtonGroup
                  orientation="horizontal"
                  value={changeShow}
                  exclusive
                  onChange={handleChange}
                >
                  <ToggleButtonIconDynamic
                    size="small"
                    value="module"
                    aria-label="module"
                  >
                    <ViewModuleIconDynamic />
                  </ToggleButtonIconDynamic>
                  <ToggleButtonIconDynamic
                    size="small"
                    value="list"
                    aria-label="list"
                  >
                    <ViewListIconDynamic />
                  </ToggleButtonIconDynamic>
                </ToggleButtonGroup>
              ) : (
                <ToggleButtonGroup
                  orientation="horizontal"
                  value={changeShowMobile}
                  exclusive
                  onChange={handleChangeMobile}
                >
                  <ToggleButtonIconDynamic
                    size="small"
                    value="module"
                    aria-label="module"
                  >
                    <ViewModuleIconDynamic />
                  </ToggleButtonIconDynamic>
                  <ToggleButtonIconDynamic
                    size="small"
                    value="list"
                    aria-label="list"
                  >
                    <ViewListIconDynamic />
                  </ToggleButtonIconDynamic>
                </ToggleButtonGroup>
              )
            ) : null}
          </div>
          {/* filters */}

          {/* card place */}
          <div
            className={
              changeShowMobile == "module"
                ? styles.module_mobile
                : changeShow == "module"
                ? styles.module
                : styles.list
            }
          >
            {apiData.products ? (
              !Array.isArray(apiData.products) &&
              apiData.products.data &&
              apiData.products.data.length >= 1 ? (
                apiData.products.data.map((product, index) => {
                  return (
                    product && (
                      <Fragment key={product.id}>
                        <ProductCard
                          data={product}
                          styleList={changeShow}
                          styleListMobile={changeShowMobile}
                        />
                        
                        {product.structure_status == 1 && (
                          <script
                            type="application/ld+json"
                            dangerouslySetInnerHTML={{
                              __html: JSON.stringify(product.data_structure),
                            }}
                          />
                        )}
                      </Fragment>
                    )
                  );
                })
              ) : (
                <p className="w-full p-4 text-center font-bold col-span-4">
                  محصولی برای نمایش موجود نیست
                </p>
              )
            ) : (
              <p className="w-full p-4 text-center font-bold col-span-4">
                محصولی برای نمایش موجود نیست
              </p>
            )}
          </div>
          {/* card place */}

          {/* pagination */}
          {apiData.products &&
          !Array.isArray(apiData.products) &&
          apiData.products.data &&
          apiData.products.last_page != 1 ? (
            <Pagination
              pagel={scrollTo}
              currentPage={pages}
              pages={apiData.products.last_page}
              links={apiData.products.links}
              slug={apiData.slug}
              type="brands"
            />
          ) : null}
          {/* pagination */}
        </>
      ) : type == "tags" ? (
        <>
          {/* filters */}
          <div
            className={`filters flex sm:flex-row flex-row-reverse sm:justify-start justify-between mb-5 h-11`}
          >
            {apiData.products &&
            !Array.isArray(apiData.products) &&
            apiData.products.data &&
            apiData.products.data.length > 0 ? (
              !mobile ? (
                <ToggleButtonGroup
                  orientation="horizontal"
                  value={changeShow}
                  exclusive
                  onChange={handleChange}
                >
                  <ToggleButtonIconDynamic
                    size="small"
                    value="module"
                    aria-label="module"
                  >
                    <ViewModuleIconDynamic />
                  </ToggleButtonIconDynamic>
                  <ToggleButtonIconDynamic
                    size="small"
                    value="list"
                    aria-label="list"
                  >
                    <ViewListIconDynamic />
                  </ToggleButtonIconDynamic>
                </ToggleButtonGroup>
              ) : (
                <ToggleButtonGroup
                  orientation="horizontal"
                  value={changeShowMobile}
                  exclusive
                  onChange={handleChangeMobile}
                >
                  <ToggleButtonIconDynamic
                    size="small"
                    value="module"
                    aria-label="module"
                  >
                    <ViewModuleIconDynamic />
                  </ToggleButtonIconDynamic>
                  <ToggleButtonIconDynamic
                    size="small"
                    value="list"
                    aria-label="list"
                  >
                    <ViewListIconDynamic />
                  </ToggleButtonIconDynamic>
                </ToggleButtonGroup>
              )
            ) : null}
          </div>
          {/* filters */}

          {/* card place */}
          <div
            className={
              changeShowMobile == "module"
                ? styles.module_mobile
                : changeShow == "module"
                ? styles.module
                : styles.list
            }
          >
            {apiData.products ? (
              !Array.isArray(apiData.products) &&
              apiData.products.data &&
              apiData.products.data.length >= 1 ? (
                apiData.products.data.map((product, index) => {
                  return (
                    product && (
                      <Fragment key={product.id}>
                        <ProductCard
                          data={product}
                          styleList={changeShow}
                          styleListMobile={changeShowMobile}
                        />
                        

                        {product.structure_status == 1 && (
                          <script
                            type="application/ld+json"
                            dangerouslySetInnerHTML={{
                              __html: JSON.stringify(product.data_structure),
                            }}
                          />
                        )}
                      </Fragment>
                    )
                  );
                })
              ) : (
                <p className="w-full p-4 text-center font-bold col-span-4">
                  محصولی برای نمایش موجود نیست
                </p>
              )
            ) : (
              <p className="w-full p-4 text-center font-bold col-span-4">
                محصولی برای نمایش موجود نیست
              </p>
            )}
          </div>
          {/* card place */}

          {/* pagination */}
          {apiData.products &&
          !Array.isArray(apiData.products) &&
          apiData.products.data &&
          apiData.products.last_page != 1 ? (
            <Pagination
              pagel={scrollTo}
              currentPage={pages}
              pages={apiData.products.last_page}
              links={apiData.products.links}
              slug={apiData.slug}
              type="tags"
            />
          ) : null}
          {/* pagination */}
        </>
      ) : (
        <>
          {/* filters */}
          <div
            className={`filters flex sm:flex-row flex-row-reverse sm:justify-start justify-between mb-5 h-11`}
          >
            {!mobile ? (
              apiData.products &&
              apiData.products.data &&
              apiData.products.data.length > 0 && (
                <Filter type="product" id={apiData.category.id} />
              )
            ) : (
              <></>
            )}
            {apiData.products &&
            !Array.isArray(apiData.products) &&
            apiData.products.data &&
            apiData.products.data.length > 0 ? (
              apiData.category.type == 0 ? (
                !mobile ? (
                  <ToggleButtonGroup
                    orientation="horizontal"
                    value={changeShow}
                    exclusive
                    onChange={handleChange}
                  >
                    <ToggleButtonIconDynamic
                      size="small"
                      value="module"
                      aria-label="module"
                    >
                      <ViewModuleIconDynamic />
                    </ToggleButtonIconDynamic>
                    <ToggleButtonIconDynamic
                      size="small"
                      value="list"
                      aria-label="list"
                    >
                      <ViewListIconDynamic />
                    </ToggleButtonIconDynamic>
                  </ToggleButtonGroup>
                ) : (
                  <ToggleButtonGroup
                    orientation="horizontal"
                    value={changeShowMobile}
                    exclusive
                    onChange={handleChangeMobile}
                  >
                    <ToggleButtonIconDynamic
                      size="small"
                      value="module"
                      aria-label="module"
                    >
                      <ViewModuleIconDynamic />
                    </ToggleButtonIconDynamic>
                    <ToggleButtonIconDynamic
                      size="small"
                      value="list"
                      aria-label="list"
                    >
                      <ViewListIconDynamic />
                    </ToggleButtonIconDynamic>
                  </ToggleButtonGroup>
                )
              ) : null
            ) : null}
            {tablet &&
              apiData.products &&
              apiData.products.data &&
              apiData.products.data.length > 0 && (
                <>
                  <Filters
                  testValue={testValue}
                    openMenu={filters}
                    onClose={() => setFilters(false)}
                    data={apiData.category.filters}
                    id={apiData.category.id}
                    scrollTo={scrollTo}
                    currentSlug={currentSlug}
                  />
                </>
              )}
          </div>
          {/* filters */}

          {/* card place */}
          <div
            className={
              apiData.category.type == 1
                ? ""
                : changeShowMobile == "module"
                ? styles.module_mobile
                : changeShow == "module"
                ? styles.module
                : styles.list
            }
          >
            {apiData.category.parent_id == null ? (
              apiData.products ? (
                !Array.isArray(apiData.products) &&
                apiData.products.data &&
                apiData.products.data.length >= 1 ? (
                  apiData.products.data.map((product, index) => {
                    return (
                      product && (
                        <Fragment key={product.id}>
                          <ProductCard
                            data={product}
                            styleList={changeShow}
                            styleListMobile={changeShowMobile}
                          />

                          {product.structure_status == 1 && (
                            <script
                              type="application/ld+json"
                              dangerouslySetInnerHTML={{
                                __html: JSON.stringify(product.data_structure),
                              }}
                            />
                          )}
                        </Fragment>
                      )
                    );
                  })
                ) : (
                  <p className="w-full p-4 text-center font-bold col-span-4">
                    محصولی برای نمایش موجود نیست
                  </p>
                )
              ) : (
                <p className="w-full p-4 text-center font-bold col-span-4">
                  محصولی برای نمایش موجود نیست
                </p>
              )
            ) : apiData.products && !Array.isArray(apiData.products) ? (
              apiData.products.data &&
              apiData.products.data.length >= 1 &&
              apiData.products.data.map((product, index) => {
                return (
                  product && (
                    <Fragment key={product.id}>
                      {apiData.category.type == 1 ? (
                        <>
                          {index >= 0 && index <= 3 ? (
                            <Card data={product} priceList={true} />
                          ) : client ? (
                            <Card data={product} priceList={true} />
                          ) : (
                            <div className={styles.skeleton}>
                              <Skeleton
                                variant="rectangular"
                                animation="wave"
                                sx={{
                                  width: "100%",
                                  height: "100%",
                                  borderRadius: "8px",
                                  "@media (max-width: 540px)": {
                                    borderRadius: "0",
                                  },
                                }}
                              />
                            </div>
                          )}
                        </>
                      ) : (
                        <>
                        <ProductCard
                              data={product}
                              styleList={changeShow}
                              styleListMobile={changeShowMobile}
                            />
                         
                        </>
                      )}
                      {product.structure_status == 1 && (
                        <script
                          type="application/ld+json"
                          dangerouslySetInnerHTML={{
                            __html: JSON.stringify(product.data_structure),
                          }}
                        />
                      )}
                    </Fragment>
                  )
                );
              })
            ) : (
              <p>محصولی برای نمایش موجود نیست</p>
            )}
          </div>
          {/* card place */}

          {/* pagination */}
          {apiData.products &&
          !Array.isArray(apiData.products) &&
          apiData.products.data &&
          apiData.products.last_page != 1 ? (
            apiData.category.scroll_mode == 0 ? (
              <>
                <Pagination
                  pagel={scrollTo}
                  currentPage={pages}
                  pages={apiData.products.last_page}
                  links={apiData.products.links}
                  slug={apiData.category.slug}
                />
              </>
            ) : apiData.category.scroll_mode == 1 ? (
              <ButtonCustom
                justifyContent="center"
                text="مشاهده بیشتر"
                title="مشاهده بیشتر"
              />
            ) : apiData.category.scroll_mode == 2 ? (
              <h5>load more</h5>
            ) : null
          ) : null}
          {/* pagination */}
        </>
      )}
    </section>
  );
}
