"use client";
import React, { useState, useEffect, use, Fragment } from "react";
import ImageCustom from "./ImageCustom";
import ButtonCustom from "./ButtonCustom";
import Radio from "@mui/material/Radio";
import RadioGroup from "@mui/material/RadioGroup";
import FormControlLabel from "@mui/material/FormControlLabel";
import FormControl from "@mui/material/FormControl";
import FormLabel from "@mui/material/FormLabel";
import TextField from "@mui/material/TextField";
import InputLabel from "@mui/material/InputLabel";
import MenuItem from "@mui/material/MenuItem";
import Select from "@mui/material/Select";
import CheckIcon from "@mui/icons-material/Check";
import Checkbox from "@mui/material/Checkbox";
import FormGroup from "@mui/material/FormGroup";

export default function PriceForm({ data = null }) {
  const groups = data && data.groups ? data.groups : null;
  const pageLength = data && data.groups.length - 1;

  const [pages, setPages] = useState("start");

  const [selectDefault, setSelectDefault] = useState("");
  const [selectChildDefault, setSelectChildDefault] = useState("");

  const [radioDefault, setRadioDefault] = useState("");

  const [colorDefault, setColorDefault] = useState("");

  const [checkDefault, setCheckDefault] = useState("");

  const [sipmleTextValue, setSipmleTextValue] = useState([]);
  const [simpleTextPosition, setSimpleTextPosition] = useState(null);

  const [disabledButton, setDisabledButton] = useState(true);

  //----------------------------------------------------------------------------------------//--
  const [parentStracture, setParentStracture] = useState([]);
  const [childStracture, setChildStracture] = useState([]);
  const [parentValues, setParentValues] = useState("");
  const [childValues, setChildValues] = useState("");
  const [multipleChildCheckbox, setMultipleChildCheckbox] = useState([]);
  const [toCall, setToCall] = useState([]);
  const [imageStracture , setImageStracture] = useState([])
  //----------------------------------------------------------------------------------------//--

  const nextHandler = (elem) => {
    if (pages < pageLength) {
      setPages((prev) => prev + 1);
    } else {
      setPages(pageLength);
    }
  };

  const prevHandler = () => {
    if (pages < 1) {
      setPages("start");
    } else {
      setPages((prev) => prev - 1);
    }
  };

  const startHandler = () => {
    setPages(0);
  };

  const inputTextStyle = {
    "& .MuiOutlinedInput-root": {
      "&.Mui-focused fieldset": {
        borderColor: data
          ? data.bgc_color
            ? data.bgc_color
            : "var(--theme-color)"
          : "var(--theme-color)",
      },
    },
    "& label.Mui-focused": {
      color: data
        ? data.bgc_color
          ? data.bgc_color
          : "var(--theme-color)"
        : "var(--theme-color)",
    },
  };

  const radioStyle = {
    color: data
      ? data.bgc_color
        ? data.bgc_color
        : "var(--theme-color)"
      : "var(--theme-color)",
    "&.Mui-checked": {
      color: data
        ? data.bgc_color
          ? data.bgc_color
          : "var(--theme-color)"
        : "var(--theme-color)",
    },
  };

  const labelStyle = {
    "&.Mui-focused": {
      color: data
        ? data.bgc_color
          ? data.bgc_color
          : "var(--theme-color)"
        : "var(--theme-color)",
    },
  };

  const selectStyle = {
    "& .MuiOutlinedInput-root": {
      "&.Mui-focused fieldset": {
        borderColor: data
          ? data.bgc_color
            ? data.bgc_color
            : "var(--theme-color)"
          : "var(--theme-color)",
      },
    },
    "& .Mui-focused": {
      color: data
        ? data.bgc_color
          ? data.bgc_color
          : "var(--theme-color)"
        : "var(--theme-color)",
    },
  };

  const selectHandler = (event, index, type) => {
    let indexOption;

    const listArray = groups[pages].children;
    const id = event.target.value;
    const imageConstant = [...imageStracture]

    if (type == "product_select_option") {
      indexOption = listArray[index].items.map((items) => items.id).indexOf(id);
    } else {
      indexOption = listArray.map((item) =>
        item.items.map((subItem) => subItem.id).indexOf(id)
      )[0];
    }

    const callConstans = [...toCall];
    const transferToCall =
      listArray[index].items[indexOption].transfer_to_call &&
      listArray[index].items[indexOption].transfer_to_call == 1
        ? true
        : false;

    callConstans[pages] = transferToCall;
    setToCall(callConstans);

    const array = childStracture[pages][index].map((item) => (item = ""));

    const parentArray = [...parentValues];
    parentValues[pages][index] = id;
    setParentValues(parentArray);

    groups.map((items) => {
      items.children.map((subItem) => {
        if (subItem.type == type) {
          subItem.items.map((child) => {
            if (child.id == id) {
              if (child.image) {
                imageConstant[pages] = child
              }
              if (child.children && !Array.isArray(child.children)) {
                array[indexOption] = child;
              } else {
                array[indexOption] = "";
              }
            }
          });
        }
      });
    });

    childStracture[pages][index] = array;
    setImageStracture(imageConstant)
  };

  const selectChildrenHandler = (event, index, childIndex) => {
    const id = event.target.value;

    const newArray = [...childValues];
    newArray[pages][index][childIndex] = id;
    setChildValues(newArray);
  };

  const radioHanler = (event, index, type) => {
    const listArray = groups[pages].children;
    

    const id = event.target.value;
    const indexRadio = Number(event.target.name);

    const array = childStracture[pages][index].map((item) => (item = ""));

    const callConstans = [...toCall];
    const imageConstant = [...imageStracture]
    const transferToCall =
      listArray[index].items[indexRadio].transfer_to_call &&
      listArray[index].items[indexRadio].transfer_to_call == 1
        ? true
        : false;

    callConstans[pages] = transferToCall;

    const parentArray = [...parentValues];
    parentValues[pages][index] = id;
    setParentValues(parentArray);

    groups.map((items) => {
      items.children.map((subItem) => {
        if (subItem.type == type) {
          subItem.items.map((child) => {
            if (child.id == id) {
              if (child.image) {
                imageConstant[pages] = child
              }
              
              if (child.children && !Array.isArray(child.children)) {
                array[indexRadio] = child;
              } else {
                array[indexRadio] = "";
              }
            }
          });
        }
      });
    });
    childStracture[pages][index] = array;
    setToCall(callConstans);
    setImageStracture(imageConstant)
  };

  const colorHandler = (id, index) => {
    const newArray = [...colorDefault];
    newArray[pages][index] = id;
    setColorDefault(newArray);
  };

  const checkboxHandler = (event, index, i) => {
    const newArray = [...checkDefault];
    if (event.target.checked) {
      newArray[pages][index][i] = true;
    } else {
      newArray[pages][index][i] = false;
    }
    setCheckDefault(newArray);
  };

  const checkboxChildHandler = (event, index, childIndex, i) => {
    const id = event.target.value;

    const newArray = [...multipleChildCheckbox];
    if (event.target.checked) {
      newArray[pages][index][childIndex][i] = id;
    } else {
      newArray[pages][index][childIndex][i] = "";
    }
    setMultipleChildCheckbox(newArray);
  };

  const simpleTextHandler = (event, index, i) => {
    const newArray = [...sipmleTextValue];
    newArray[pages][index][i] = event.target.value;
    setSipmleTextValue(newArray);
  };

  useEffect(() => {
    const selectValueDefault = groups.map((items) => {
      return items.children.map((subItems) => {
        if (subItems.type == "simple_select_option") {
          return subItems.items[0].id;
        } else {
          return "";
        }
      });
    });

    const selectChildValueDefault = groups.map((items) => {
      return items.children.map((subItems) => {
        if (subItems.type == "simple_select_option") {
          return subItems.items.map((childItem) => {
            if (childItem.children && !Array.isArray(childItem.children)) {
              return childItem.children.items[0].id;
            } else {
              return "";
            }
          });
        } else if (subItems.type == "simple_radio") {
          return subItems.items.map((childItem) => {
            if (childItem.children && !Array.isArray(childItem.children)) {
              return [false];
            } else {
              return "";
            }
          });
        } else {
          return "";
        }
      });
    });

    const radioValueDefault = groups.map((items) => {
      return items.children.map((subItems) => {
        if (subItems.type == "simple_radio") {
          return subItems.items[0].id;
        } else {
          return "";
        }
      });
    });

    const colorValueDefault = groups.map((items) => {
      return items.children.map((subItems) => {
        if (subItems.type == "radio_color") {
          return subItems.items[0].id;
        } else {
          return "";
        }
      });
    });

    const checkboxValueDefault = groups.map((items) => {
      return items.children.map((subItems) => {
        if (subItems.type == "simple_checkbox") {
          return subItems.items.map((checkbox) => {
            return false;
          });
        } else {
          return "";
        }
      });
    });

    setCheckDefault(checkboxValueDefault);
    setSelectChildDefault(selectChildValueDefault);
    setColorDefault(colorValueDefault);
    setSelectDefault(selectValueDefault);
    setRadioDefault(radioValueDefault);
  }, []);

  useEffect(() => {
    // if (groups && groups[pages]) {
    const textValue = groups.map((items) => {
      return items.children.map((subItems, index) => {
        if (subItems.type == "simple_text") {
          setSimpleTextPosition(index);
          return subItems.items.map((checkbox) => {
            return "";
          });
        } else {
          return "";
        }
      });
    });

    setSipmleTextValue(textValue);
    // }
  }, [pages]);

  useEffect(() => {
    const disabled = sipmleTextValue[pages]
      ? sipmleTextValue[pages][simpleTextPosition]
        ? !sipmleTextValue[pages][simpleTextPosition].every(
            (item) => item !== ""
          )
        : false
      : false;
    setDisabledButton(disabled);
  }, [pages, sipmleTextValue]);

  //-------------------------------------------stractures effect----------------------------------------------\\
  useEffect(() => {
    const dataChild = groups.map((items) => {
      return items.children.map((subItems) => {
        return subItems.items.map((child, i, array) => {
          if (i == 0) {
            if (child.children && !Array.isArray(child.children)) {
              return child;
            } else {
              return "";
            }
          } else {
            return "";
          }
        });
      });
    });

    const valuesChild = groups.map((items) => {
      return items.children.map((subItems) => {
        return subItems.items.map((child, i) => {
          if (child.children && !Array.isArray(child.children)) {
            return [child.children.items[0].id];
          } else {
            return "";
          }
        });
      });
    });

    const valuesParent = groups.map((items) => {
      return items.children.map((subItems) => {
        return subItems.items[0].id;
      });
    });

    const dataParent = groups.map((items) => {
      return items.children.map((subItems) => {
        return subItems.items.map(() => {
          return "";
        });
      });
    });

    const childChekbox = groups.map((items) => {
      return items.children.map((subItems) => {
        return subItems.items.map((child, i) => {
          if (child.children && !Array.isArray(child.children)) {
            return child.children.items.map((hhh) => {
              return "";
            });
          } else {
            return "";
          }
        });
      });
    });

    const toCallConstans = groups.map(() => {
      return false;
    });

    // groups.map((items, i) => {
    //   items.children.map((childItem) => {
    //     if (childItem.items[0].transfer_to_call == 1) {
    //       toCallConstans[i] = true;
    //     }
    //   });
    // });


    const imageConstant = groups.map((items)=>{
      if(items.image) {
        return items
      }else {
        return null
      }
    })

      
    
    setImageStracture(imageConstant)
    setToCall(toCallConstans);
    setMultipleChildCheckbox(childChekbox);
    setParentStracture(dataParent);
    setParentValues(valuesParent);
    setChildValues(valuesChild);
    setChildStracture(dataChild);
  }, []);

  // useEffect(() => {
  //   const jsString = ` ${data.form_script}`;
  //   try {
  //     eval(jsString);
  //   } catch (error) {
  //     console.error("error", error);
  //   }
  // }, [pages]);

  // console.log(pages != "start" && childStracture[pages]);

  const colorChildHandler = (id, index, childIndex) => {
    const newArray = [...childValues];
    newArray[pages][index][childIndex] = id;
    setChildValues(newArray);
  };

  const radioChildHandler = (event, index, childIndex) => {
    const id = event.target.value;
    const newArray = [...childValues];
    newArray[pages][index][childIndex] = id;
    setChildValues(newArray);
  };

  const multipleCheckboxHandler = (event, index, i, type) => {
    const callConstans = [...toCall];
    let transferToCall = false;

    const id = event.target.value;
    const array = childStracture[pages][index];
    let newArray = [...parentStracture];

    if (event.target.checked) {
      newArray[pages][index][i] = id;
      groups.map((items) => {
        items.children.map((subItem) => {
          if (subItem.type == type) {
            subItem.items.map((child) => {
              if (child.id == id) {
                transferToCall = child.transfer_to_call == 1 ? true : false;
                if (child.children && !Array.isArray(child.children)) {
                  array[i] = child;
                } else {
                  array[i] = "";
                }
              }
            });
          }
        });
      });
    } else {
      newArray[pages][index][i] = "";
      groups.map((items) => {
        items.children.map((subItem) => {
          if (subItem.type == type) {
            subItem.items.map((child) => {
              if (child.id == id) {
                transferToCall = false;
                if (child.children && !Array.isArray(child.children)) {
                  array[i] = "";
                } else {
                  array[i] = "";
                }
              }
            });
          }
        });
      });
    }
    setParentStracture(newArray);

    childStracture[pages][index] = array;
    callConstans[pages] = transferToCall;
    setToCall(callConstans);
  };

  const multipleColorHandler = (event, index, i, type) => {
    let newArray = [...parentStracture];
    const id = event.target.value;
    const array = childStracture[pages][index];

    if (event.target.checked) {
      newArray[pages][index][i] = id;
      groups.map((items) => {
        items.children.map((subItem) => {
          if (subItem.type == type) {
            subItem.items.map((child) => {
              if (child.id == id) {
                if (child.children && !Array.isArray(child.children)) {
                  array[i] = child;
                } else {
                  array[i] = "";
                }
              }
            });
          }
        });
      });
    } else {
      newArray[pages][index][i] = "";
      groups.map((items) => {
        items.children.map((subItem) => {
          if (subItem.type == type) {
            subItem.items.map((child) => {
              if (child.id == id) {
                if (child.children && !Array.isArray(child.children)) {
                  array[i] = "";
                } else {
                  array[i] = "";
                }
              }
            });
          }
        });
      });
    }
    setParentStracture(newArray);

    childStracture[pages][index] = array;
  };

  const multipleChildColorHandler = (event, index, childIndex, i) => {
    let newArray = [...multipleChildCheckbox];
    const id = event.target.value;

    if (event.target.checked) {
      newArray[pages][index][childIndex][i] = id;
    } else {
      newArray[pages][index][childIndex][i] = "";
    }
    setMultipleChildCheckbox(newArray);
  };

  const radioChildHanler = (event, index, childIndex) => {};

  return (
    <>
      <div
        id={data.id}
        className={`${(pages != "start" && pages != "support")
            ? groups && groups[pages].layout_type == "row"
              ? "h-[365.5px]"
              : "h-auto"
            : "h-[365.5px]"
        } mb-12 rounded-lg border-2`}
        style={{ borderColor: data.bgc_color }}
      >
        {/* title */}
        <div
          className={`title h-11 text-center text-white font-medium leading-[44px] sm:text-[20px]`}
          style={{ backgroundColor: data.bgc_color }}
        >
          {pages == "start"  || pages == "support" ? pages == "support" ? "تماس" : data.title : groups && groups[pages].title}
        </div>
        {/* title */}

        {/* body */}
        <div
          className={`body ${
            pages != "start" && pages != "support"
              ? groups && groups[pages].layout_type == "row"
                ? "h-[317.5px]"
                : "h-auto"
              : "h-[317.5px]"
          } bg-white rounded-b-lg`}
        >
          {pages == "start" ? (
            <div className="grid grid-cols-2 gap-2 items-center h-full">
              <div className="h-full">
                <ImageCustom
                  mobileData={data.mobile_image}
                  mobileTitle={data.mobile_image_alt}
                  mobileAlt={data.mobile_image_alt}
                  size="original"
                  loading={"lazy"}
                  data={data.image}
                  alt={data.image_alt}
                  title={data.image_alt}
                  fullWidth={false}
                  width={500}
                  height={140}
                />
              </div>
              <div className="flex items-center gap-4 flex-col p-4">
                <div className="text-lg">{data.name}</div>
                <ButtonCustom
                  text={data.start}
                  title={data.start}
                  color={data.btn_color}
                  textColor={data.btn_inner_color}
                  onClick={startHandler}
                  id={"start_price_form"}
                />
              </div>
            </div>
          ) :pages == "support" ?(
          
          <div className="flex flex-col justify-between items-center p-4 h-full">
            <div>
              <div className="text-center">باشماره زیر تماس حاصل فرمایید</div>
              <div className="text-center">091212345678</div>
            </div>

            <ButtonCustom
                      text="بازگشت"
                      title="بازگشت"
                      textColor={data.btn_inner_color}
                      color={data.btn_color}
                      onClick={()=>setPages("start")}
                    />
          </div>
          
          
        
        )  : (
            <div
              className={`p-4 flex flex-col justify-between h-full 
            ${
              pages != "start"
                ? groups && groups[pages].layout_type == "row"
                  ? "gap-0"
                  : "gap-4"
                : "gap-0"
            }`}
            >
              <div
                className={`grid ${
                  groups && groups[pages].layout_type == "row"
                    ? data.groups[pages].image
                      ? "grid-cols-3"
                      : "grid-cols-2"
                    : "grid-cols-2"
                } gap-4`}
              >
                {groups && groups[pages].layout_type == "row" ? (
                  // row
                  <>
                    {groups &&
                      groups[pages].children.map((items, index) => (
                        <Fragment key={items.id}>
                          {/* ****************parent elements************************** */}
                          <div>
                            {items.type == "simple_radio" ? (
                              <FormControl>
                                {items.title && (
                                  <FormLabel id={items.id} sx={labelStyle}>
                                    {items.title}
                                  </FormLabel>
                                )}
                                <RadioGroup
                                  onChange={(event) =>
                                    radioHanler(event, index, items.type)
                                  }
                                  aria-labelledby={items.id}
                                  value={parentValues[pages][index]}
                                  name={items.type}
                                >
                                  {items.items.map((subItems, i) => (
                                    <FormControlLabel
                                      key={subItems.id}
                                      value={subItems.id}
                                      name={i}
                                      control={
                                        <Radio size="small" sx={radioStyle} />
                                      }
                                      label={subItems.name}
                                    />
                                  ))}
                                </RadioGroup>
                                {items.hint && (
                                  <div className="text-xs text-red-700">
                                    {items.hint}
                                  </div>
                                )}
                              </FormControl>
                            ) : items.type == "simple_text" ? (
                              <div className="grid grid-cols-1 gap-3">
                                {items.title && <div>{items.title}</div>}

                                {items.items.map((subItems, i) => (
                                  <TextField
                                    sx={inputTextStyle}
                                    onChange={(event) =>
                                      simpleTextHandler(event, index, i)
                                    }
                                    focused
                                    value={sipmleTextValue[pages][index][i]}
                                    key={subItems.id}
                                    size="small"
                                    id={subItems.id}
                                    label={subItems.name}
                                    variant="outlined"
                                    type={
                                      subItems.input_type
                                        ? subItems.input_type
                                        : "text"
                                    }
                                  />
                                ))}

                                {items.title && (
                                  <div className="text-xs text-red-700">
                                    {items.hint}
                                  </div>
                                )}
                              </div>
                            ) : items.type == "simple_select_option" ? (
                              <div className="grid grid-cols-1 gap-3">
                                <FormControl
                                  fullWidth
                                  size="small"
                                  sx={selectStyle}
                                >
                                  <InputLabel id={items.id}>
                                    {items.title}
                                  </InputLabel>
                                  <Select
                                    labelId={items.id}
                                    id={items.id}
                                    value={parentValues[pages][index]}
                                    label={items.title}
                                    onChange={(event) =>
                                      selectHandler(event, index, items.type)
                                    }
                                  >
                                    {items.items.map((subItems, i) => (
                                      <MenuItem
                                        key={subItems.id}
                                        value={subItems.id}
                                        name={i}
                                      >
                                        {subItems.name}
                                      </MenuItem>
                                    ))}
                                  </Select>
                                </FormControl>
                                {items.hint && (
                                  <div
                                    className="text-justify text-sm"
                                    dangerouslySetInnerHTML={{
                                      __html: items.hint,
                                    }}
                                  />
                                )}
                              </div>
                            ) : items.type == "radio_color" ? (
                              <div className="grid grid-cols-1 gap-3">
                                <div>
                                  {items.title && (
                                    <div className="text-sm mb-1">
                                      {items.title}
                                    </div>
                                  )}
                                  <div className="flex items-center gap-3">
                                    {items.items.map((subItems, i) => (
                                      <div
                                        onClick={() =>
                                          colorHandler(subItems.id, index)
                                        }
                                        key={subItems.id}
                                        className="w-5 h-5 rounded-sm border cursor-pointer flex items-center justify-center"
                                        style={{
                                          backgroundColor: subItems.color_code,
                                        }}
                                      >
                                        {subItems.id ==
                                          colorDefault[pages][index] && (
                                            <CheckIcon
                                            fontSize="large"
                                            sx={{
                                              stroke: "#fff",
                                            }}
                                          />
                                        )}
                                      </div>
                                    ))}
                                  </div>
                                </div>
                                {items.hint && (
                                  <div
                                    className="text-justify text-sm"
                                    dangerouslySetInnerHTML={{
                                      __html: items.hint,
                                    }}
                                  />
                                )}
                              </div>
                            ) : items.type == "simple_checkbox" ? (
                              <FormControl component="div" variant="standard">
                                {items.title && (
                                  <FormLabel component="legend" sx={labelStyle}>
                                    {items.title}
                                  </FormLabel>
                                )}
                                <FormGroup>
                                  {items.items.map((subItems, i) => (
                                    <FormControlLabel
                                      onChange={(event) =>
                                        checkboxHandler(event, index, i)
                                      }
                                      checked={checkDefault[pages][index][i]}
                                      key={subItems.id}
                                      control={
                                        <Checkbox
                                          size="small"
                                          sx={radioStyle}
                                        />
                                      }
                                      label={subItems.name}
                                    />
                                  ))}
                                </FormGroup>
                              </FormControl>
                            ) : items.type == "product_radio" ? (
                              <>
                                <FormControl>
                                  {items.title && (
                                    <FormLabel id={items.id} sx={labelStyle}>
                                      {items.title}
                                    </FormLabel>
                                  )}
                                  <RadioGroup
                                    onChange={(event) =>
                                      radioHanler(event, index, items.type)
                                    }
                                    aria-labelledby={items.id}
                                    value={parentValues[pages][index]}
                                    name={items.type}
                                  >
                                    {items.items.map((subItems, i) => (
                                      <FormControlLabel
                                        key={subItems.id}
                                        value={subItems.id}
                                        name={i}
                                        control={
                                          <Radio size="small" sx={radioStyle} />
                                        }
                                        label={subItems.name}
                                      />
                                    ))}
                                  </RadioGroup>
                                  {items.hint && (
                                    <div className="text-xs text-red-700">
                                      {items.hint}
                                    </div>
                                  )}
                                </FormControl>
                              </>
                            ) : items.type == "product_checkbox" ? (
                              <>
                                <FormControl component="div" variant="standard">
                                  {items.title && (
                                    <FormLabel
                                      component="legend"
                                      sx={labelStyle}
                                    >
                                      {items.title}
                                    </FormLabel>
                                  )}
                                  <FormGroup>
                                    {items.items.map((subItems, i) => (
                                      <FormControlLabel
                                        key={subItems.id}
                                        value={subItems.id}
                                        onChange={(event) =>
                                          multipleCheckboxHandler(
                                            event,
                                            index,
                                            i,
                                            items.type
                                          )
                                        }
                                        control={
                                          <Checkbox
                                            checked={
                                              parentStracture[pages][index][
                                                i
                                              ] != ""
                                                ? true
                                                : false
                                            }
                                            inputProps={{
                                              "aria-label": "controlled",
                                            }}
                                            size="small"
                                            sx={radioStyle}
                                          />
                                        }
                                        label={subItems.name}
                                      />
                                    ))}
                                  </FormGroup>
                                </FormControl>
                              </>
                            ) : items.type == "product_select_option" ? (
                              <>
                                <div className="grid grid-cols-1 gap-3">
                                  <FormControl
                                    fullWidth
                                    size="small"
                                    sx={selectStyle}
                                  >
                                    <InputLabel id={items.id}>
                                      {items.title}
                                    </InputLabel>
                                    <Select
                                      labelId={items.id}
                                      id={items.id}
                                      value={parentValues[pages][index]}
                                      label={items.title}
                                      onChange={(event) =>
                                        selectHandler(event, index, items.type)
                                      }
                                    >
                                      {items.items.map((subItems, i) => (
                                        <MenuItem
                                          key={subItems.id}
                                          value={subItems.id}
                                        >
                                          {subItems.name}
                                        </MenuItem>
                                      ))}
                                    </Select>
                                  </FormControl>
                                  {items.hint && (
                                    <div
                                      className="text-justify text-sm"
                                      dangerouslySetInnerHTML={{
                                        __html: items.hint,
                                      }}
                                    />
                                  )}
                                </div>
                              </>
                            ) : items.type == "checkbox_color" ? (
                              <div className="grid grid-cols-1 gap-3">
                                <div>
                                  {items.title && (
                                    <div className="text-sm mb-1">
                                      {items.title}
                                    </div>
                                  )}
                                  <div className="flex items-center gap-3">
                                    {items.items.map((subItems, i) => (
                                      <div key={subItems.id}>
                                        <input
                                          onClick={(event) =>
                                            multipleColorHandler(
                                              event,
                                              index,
                                              i,
                                              items.type
                                            )
                                          }
                                          type="checkbox"
                                          id={subItems.id}
                                          name="mutipleColor"
                                          value={subItems.id}
                                          className="hidden"
                                        ></input>
                                        <label
                                          htmlFor={subItems.id}
                                          className="w-5 h-5 rounded-sm border cursor-pointer flex items-center justify-center"
                                          style={{
                                            backgroundColor:
                                              subItems.color_code,
                                          }}
                                        >
                                          {subItems.id ==
                                            parentStracture[pages][index][
                                              i
                                            ] && (
                                            <CheckIcon
                                              fontSize="large"
                                              sx={{
                                                stroke: "#fff",
                                              }}
                                            />
                                          )}
                                        </label>
                                      </div>
                                    ))}
                                  </div>
                                </div>
                                {items.hint && (
                                  <div
                                    className="text-justify text-sm"
                                    dangerouslySetInnerHTML={{
                                      __html: items.hint,
                                    }}
                                  />
                                )}
                              </div>
                            ) : (
                              "test"
                            )}
                          </div>
                          {/* ****************child elements************************** */}
                          {pages != "start" &&
                            childStracture.length > 0 &&
                            childStracture[pages][index].map(
                              (childItem, childIndex) =>
                                childItem != "" && (
                                  <div key={childItem.id}>
                                    {childItem.children.item_type ==
                                    "simple_radio" ? (
                                      <FormControl>
                                        {childItem.children.title && (
                                          <FormLabel
                                            id={childItem.children.id}
                                            sx={labelStyle}
                                          >
                                            {childItem.children.title}
                                          </FormLabel>
                                        )}
                                        <RadioGroup
                                          onChange={(event) =>
                                            radioChildHandler(
                                              event,
                                              index,
                                              childIndex
                                            )
                                          }
                                          aria-labelledby={
                                            childItem.children.id
                                          }
                                          value={
                                            childValues[pages][index][
                                              childIndex
                                            ]
                                          }
                                          name={childItem.children.type}
                                        >
                                          {childItem.children.items.map(
                                            (subItems, i) => (
                                              <FormControlLabel
                                                key={subItems.id}
                                                value={subItems.id}
                                                name={i}
                                                control={
                                                  <Radio
                                                    size="small"
                                                    sx={radioStyle}
                                                  />
                                                }
                                                label={subItems.name}
                                              />
                                            )
                                          )}
                                        </RadioGroup>
                                        {childItem.children.hint && (
                                          <div className="text-xs text-red-700">
                                            {childItem.children.hint}
                                          </div>
                                        )}
                                      </FormControl>
                                    ) : childItem.children.item_type ==
                                      "simple_text" ? (
                                      <div className="grid grid-cols-1 gap-3">
                                        {childItem.children.title && (
                                          <div>{childItem.children.title}</div>
                                        )}

                                        {childItem.children.items.map(
                                          (subItems, i) => (
                                            <TextField
                                              sx={inputTextStyle}
                                              focused
                                              key={subItems.id}
                                              size="small"
                                              id={subItems.id}
                                              label={subItems.name}
                                              variant="outlined"
                                              type={
                                                subItems.input_type
                                                  ? subItems.input_type
                                                  : "text"
                                              }
                                            />
                                          )
                                        )}

                                        {childItem.children.hint && (
                                          <div className="text-xs text-red-700">
                                            {childItem.children.hint}
                                          </div>
                                        )}
                                      </div>
                                    ) : childItem.children.item_type ==
                                      "simple_select_option" ? (
                                      <div className="grid grid-cols-1 gap-3">
                                        <FormControl
                                          fullWidth
                                          size="small"
                                          sx={selectStyle}
                                        >
                                          <InputLabel
                                            id={childItem.children.id}
                                          >
                                            {childItem.children.title}
                                          </InputLabel>
                                          <Select
                                            labelId={childItem.children.id}
                                            id={childItem.children.id}
                                            value={
                                              childValues[pages][index][
                                                childIndex
                                              ]
                                            }
                                            label={childItem.children.title}
                                            onChange={(event) =>
                                              selectChildrenHandler(
                                                event,
                                                index,
                                                childIndex
                                              )
                                            }
                                          >
                                            {childItem.children.items.map(
                                              (subItems) => (
                                                <MenuItem
                                                  key={subItems.id}
                                                  value={subItems.id}
                                                >
                                                  {subItems.name}
                                                </MenuItem>
                                              )
                                            )}
                                          </Select>
                                        </FormControl>
                                        {childItem.hint && (
                                          <div
                                            className="text-justify text-sm"
                                            dangerouslySetInnerHTML={{
                                              __html: childItem.hint,
                                            }}
                                          />
                                        )}
                                      </div>
                                    ) : childItem.children.item_type ==
                                      "radio_color" ? (
                                      <div className="grid grid-cols-1 gap-3">
                                        <div>
                                          {childItem.children.title && (
                                            <div className="text-sm mb-1">
                                              {childItem.children.title}
                                            </div>
                                          )}
                                          <div className="flex items-center gap-3">
                                            {childItem.children.items.map(
                                              (subItems, i) => (
                                                <div
                                                  onClick={() =>
                                                    colorChildHandler(
                                                      subItems.id,
                                                      index,
                                                      childIndex
                                                    )
                                                  }
                                                  key={subItems.id}
                                                  className="w-5 h-5 rounded-sm border cursor-pointer flex items-center justify-center"
                                                  style={{
                                                    backgroundColor:
                                                      subItems.color_code,
                                                  }}
                                                >
                                                  {subItems.id ==
                                                    childValues[pages][index][
                                                      childIndex
                                                    ] && (
                                                    <CheckIcon
                                                      fontSize="large"
                                                      sx={{
                                                        stroke: "#fff",
                                                      }}
                                                    />
                                                  )}
                                                </div>
                                              )
                                            )}
                                          </div>
                                        </div>
                                        {childItem.children.hint && (
                                          <div
                                            className="text-justify text-sm"
                                            dangerouslySetInnerHTML={{
                                              __html: childItem.children.hint,
                                            }}
                                          />
                                        )}
                                      </div>
                                    ) : childItem.children.item_type ==
                                      "simple_checkbox" ? (
                                      <FormControl
                                        component="div"
                                        variant="standard"
                                      >
                                        {childItem.children.title && (
                                          <FormLabel
                                            component="legend"
                                            sx={labelStyle}
                                          >
                                            {childItem.children.title}
                                          </FormLabel>
                                        )}
                                        <FormGroup>
                                          {childItem.children.items.map(
                                            (subItems, i) => {
                                              return (
                                                <FormControlLabel
                                                  onChange={(event) =>
                                                    checkboxChildHandler(
                                                      event,
                                                      index,
                                                      childIndex,
                                                      i
                                                    )
                                                  }
                                                  checked={
                                                    multipleChildCheckbox[
                                                      pages
                                                    ][index][childIndex][i] !=
                                                    ""
                                                      ? true
                                                      : false
                                                  }
                                                  key={subItems.id}
                                                  control={
                                                    <Checkbox
                                                      size="small"
                                                      sx={radioStyle}
                                                      value={subItems.id}
                                                    />
                                                  }
                                                  label={subItems.name}
                                                />
                                              );
                                            }
                                          )}
                                        </FormGroup>
                                      </FormControl>
                                    ) : childItem.children.item_type ==
                                      "product_radio" ? (
                                      <>
                                        <FormControl>
                                          {childItem.children.title && (
                                            <FormLabel
                                              id={childItem.children.id}
                                              sx={labelStyle}
                                            >
                                              {childItem.children.title}
                                            </FormLabel>
                                          )}
                                          <RadioGroup
                                            onChange={(event) =>
                                              radioChildHandler(
                                                event,
                                                index,
                                                childIndex
                                              )
                                            }
                                            aria-labelledby={items.id}
                                            value={
                                              childValues[pages][index][
                                                childIndex
                                              ]
                                            }
                                            name={items.type}
                                          >
                                            {childItem.children.items.map(
                                              (subItems, i) => (
                                                <FormControlLabel
                                                  key={subItems.id}
                                                  value={subItems.id}
                                                  name={i}
                                                  control={
                                                    <Radio
                                                      size="small"
                                                      sx={radioStyle}
                                                    />
                                                  }
                                                  label={subItems.name}
                                                />
                                              )
                                            )}
                                          </RadioGroup>
                                          {childItem.children.hint && (
                                            <div className="text-xs text-red-700">
                                              {childItem.children.hint}
                                            </div>
                                          )}
                                        </FormControl>
                                      </>
                                    ) : childItem.children.item_type ==
                                      "product_checkbox" ? (
                                      <>
                                        <FormControl
                                          component="div"
                                          variant="standard"
                                        >
                                          {childItem.children.title && (
                                            <FormLabel
                                              component="legend"
                                              sx={labelStyle}
                                            >
                                              {childItem.children.title}
                                            </FormLabel>
                                          )}
                                          <FormGroup>
                                            {childItem.children.items.map(
                                              (subItems, i) => (
                                                <FormControlLabel
                                                  onChange={(event) =>
                                                    checkboxChildHandler(
                                                      event,
                                                      index,
                                                      childIndex,
                                                      i
                                                    )
                                                  }
                                                  checked={
                                                    multipleChildCheckbox[
                                                      pages
                                                    ][index][childIndex][i] !=
                                                    ""
                                                      ? true
                                                      : false
                                                  }
                                                  key={subItems.id}
                                                  control={
                                                    <Checkbox
                                                      size="small"
                                                      sx={radioStyle}
                                                      value={subItems.id}
                                                    />
                                                  }
                                                  label={subItems.name}
                                                />
                                              )
                                            )}
                                          </FormGroup>
                                        </FormControl>
                                      </>
                                    ) : childItem.children.item_type ==
                                      "product_select_option" ? (
                                      <>
                                        <div className="grid grid-cols-1 gap-3">
                                          <FormControl
                                            fullWidth
                                            size="small"
                                            sx={selectStyle}
                                          >
                                            <InputLabel
                                              id={childItem.children.id}
                                            >
                                              {childItem.children.title}
                                            </InputLabel>
                                            <Select
                                              labelId={childItem.children.id}
                                              id={childItem.children.id}
                                              value={
                                                childValues[pages][index][
                                                  childIndex
                                                ]
                                              }
                                              label={childItem.children.title}
                                              onChange={(event) =>
                                                selectChildrenHandler(
                                                  event,
                                                  index,
                                                  childIndex
                                                )
                                              }
                                            >
                                              {childItem.children.items.map(
                                                (subItems, i) => (
                                                  <MenuItem
                                                    key={subItems.id}
                                                    value={subItems.id}
                                                  >
                                                    {subItems.name}
                                                  </MenuItem>
                                                )
                                              )}
                                            </Select>
                                          </FormControl>
                                          {childItem.children.hint && (
                                            <div
                                              className="text-justify text-sm"
                                              dangerouslySetInnerHTML={{
                                                __html: childItem.children.hint,
                                              }}
                                            />
                                          )}
                                        </div>
                                      </>
                                    ) : childItem.children.item_type ==
                                      "checkbox_color" ? (
                                      <div className="grid grid-cols-1 gap-3">
                                        <div>
                                          {childItem.children.title && (
                                            <div className="text-sm mb-1">
                                              {childItem.children.title}
                                            </div>
                                          )}
                                          <div className="flex items-center gap-3">
                                            {childItem.children.items.map(
                                              (subItems, i) => (
                                                <div key={subItems.id}>
                                                  <input
                                                    onClick={(event) =>
                                                      multipleChildColorHandler(
                                                        event,
                                                        index,
                                                        childIndex,
                                                        i
                                                      )
                                                    }
                                                    type="checkbox"
                                                    id={subItems.id}
                                                    name="mutipleColor"
                                                    value={subItems.id}
                                                    className="hidden"
                                                  ></input>
                                                  <label
                                                    htmlFor={subItems.id}
                                                    className="w-5 h-5 rounded-sm border cursor-pointer flex items-center justify-center"
                                                    style={{
                                                      backgroundColor:
                                                        subItems.color_code,
                                                    }}
                                                  >
                                                    {subItems.id ==
                                                      multipleChildCheckbox[
                                                        pages
                                                      ][index][childIndex][
                                                        i
                                                      ] && (
                                                      <CheckIcon
                                                        fontSize="large"
                                                        sx={{
                                                          stroke: "#fff",
                                                        }}
                                                      />
                                                    )}
                                                  </label>
                                                </div>
                                              )
                                            )}
                                          </div>
                                        </div>
                                        {childItem.children.hint && (
                                          <div
                                            className="text-justify text-sm"
                                            dangerouslySetInnerHTML={{
                                              __html: childItem.children.hint,
                                            }}
                                          />
                                        )}
                                      </div>
                                    ) : (
                                      "test"
                                    )}
                                  </div>
                                )
                            )}
                        </Fragment>
                      ))}
                  </>
                ) : (
                  // column
                  <div className="grid grid-cols-1 gap-4">
                    {groups &&
                      groups[pages].children.map((items, index) => (
                        <Fragment key={items.id}>
                          {/* ****************parent elements************************** */}
                          <div>
                            {items.type == "simple_radio" ? (
                              <FormControl>
                                {items.title && (
                                  <FormLabel id={items.id} sx={labelStyle}>
                                    {items.title}
                                  </FormLabel>
                                )}
                                <RadioGroup
                                  onChange={(event) =>
                                    radioHanler(event, index, items.type)
                                  }
                                  aria-labelledby={items.id}
                                  value={parentValues[pages][index]}
                                  name={items.type}
                                >
                                  {items.items.map((subItems, i) => (
                                    <FormControlLabel
                                      key={subItems.id}
                                      value={subItems.id}
                                      name={i}
                                      control={
                                        <Radio size="small" sx={radioStyle} />
                                      }
                                      label={subItems.name}
                                    />
                                  ))}
                                </RadioGroup>
                                {items.hint && (
                                  <div className="text-xs text-red-700">
                                    {items.hint}
                                  </div>
                                )}
                              </FormControl>
                            ) : items.type == "simple_text" ? (
                              <div className="grid grid-cols-1 gap-3">
                                {items.title && <div>{items.title}</div>}

                                {items.items.map((subItems, i) => (
                                  <TextField
                                    sx={inputTextStyle}
                                    onChange={(event) =>
                                      simpleTextHandler(event, index, i)
                                    }
                                    focused
                                    value={sipmleTextValue[pages][index][i]}
                                    key={subItems.id}
                                    size="small"
                                    id={subItems.id}
                                    label={subItems.name}
                                    variant="outlined"
                                    type={
                                      subItems.input_type
                                        ? subItems.input_type
                                        : "text"
                                    }
                                  />
                                ))}

                                {items.title && (
                                  <div className="text-xs text-red-700">
                                    {items.hint}
                                  </div>
                                )}
                              </div>
                            ) : items.type == "simple_select_option" ? (
                              <div className="grid grid-cols-1 gap-3">
                                <FormControl
                                  fullWidth
                                  size="small"
                                  sx={selectStyle}
                                >
                                  <InputLabel id={items.id}>
                                    {items.title}
                                  </InputLabel>
                                  <Select
                                    labelId={items.id}
                                    id={items.id}
                                    value={selectDefault[pages][index]}
                                    label={items.title}
                                    onChange={(event) =>
                                      selectHandler(event, index, items.type)
                                    }
                                  >
                                    {items.items.map((subItems, i) => (
                                      <MenuItem
                                        key={subItems.id}
                                        value={subItems.id}
                                        name={i}
                                      >
                                        {subItems.name}
                                      </MenuItem>
                                    ))}
                                  </Select>
                                </FormControl>
                                {items.hint && (
                                  <div
                                    className="text-justify text-sm"
                                    dangerouslySetInnerHTML={{
                                      __html: items.hint,
                                    }}
                                  />
                                )}
                              </div>
                            ) : items.type == "radio_color" ? (
                              <div className="grid grid-cols-1 gap-3">
                                <div>
                                  {items.title && (
                                    <div className="text-sm mb-1">
                                      {items.title}
                                    </div>
                                  )}
                                  <div className="flex items-center gap-3">
                                    {items.items.map((subItems, i) => (
                                      <div
                                        onClick={() =>
                                          colorHandler(subItems.id, index)
                                        }
                                        key={subItems.id}
                                        className="w-5 h-5 rounded-sm border cursor-pointer flex items-center justify-center"
                                        style={{
                                          backgroundColor: subItems.color_code,
                                        }}
                                      >
                                        {subItems.id ==
                                          colorDefault[pages][index] && (
                                            <CheckIcon
                                            fontSize="large"
                                            sx={{
                                              stroke: "#fff",
                                            }}
                                          />
                                        )}
                                      </div>
                                    ))}
                                  </div>
                                </div>
                                {items.hint && (
                                  <div
                                    className="text-justify text-sm"
                                    dangerouslySetInnerHTML={{
                                      __html: items.hint,
                                    }}
                                  />
                                )}
                              </div>
                            ) : items.type == "simple_checkbox" ? (
                              <FormControl component="div" variant="standard">
                                {items.title && (
                                  <FormLabel component="legend" sx={labelStyle}>
                                    {items.title}
                                  </FormLabel>
                                )}
                                <FormGroup>
                                  {items.items.map((subItems, i) => (
                                    <FormControlLabel
                                      onChange={(event) =>
                                        checkboxHandler(event, index, i)
                                      }
                                      checked={checkDefault[pages][index][i]}
                                      key={subItems.id}
                                      control={
                                        <Checkbox
                                          size="small"
                                          sx={radioStyle}
                                        />
                                      }
                                      label={subItems.name}
                                    />
                                  ))}
                                </FormGroup>
                              </FormControl>
                            ) : items.type == "product_radio" ? (
                              <>
                                <FormControl>
                                  {items.title && (
                                    <FormLabel id={items.id} sx={labelStyle}>
                                      {items.title}
                                    </FormLabel>
                                  )}
                                  <RadioGroup
                                    onChange={(event) =>
                                      radioHanler(event, index, items.type)
                                    }
                                    aria-labelledby={items.id}
                                    value={parentValues[pages][index]}
                                    name={items.type}
                                  >
                                    {items.items.map((subItems, i) => (
                                      <FormControlLabel
                                        key={subItems.id}
                                        value={subItems.id}
                                        name={i}
                                        control={
                                          <Radio size="small" sx={radioStyle} />
                                        }
                                        label={subItems.name}
                                      />
                                    ))}
                                  </RadioGroup>
                                  {items.hint && (
                                    <div className="text-xs text-red-700">
                                      {items.hint}
                                    </div>
                                  )}
                                </FormControl>
                              </>
                            ) : items.type == "product_checkbox" ? (
                              <>
                                <FormControl component="div" variant="standard">
                                  {items.title && (
                                    <FormLabel
                                      component="legend"
                                      sx={labelStyle}
                                    >
                                      {items.title}
                                    </FormLabel>
                                  )}
                                  <FormGroup>
                                    {items.items.map((subItems, i) => (
                                      <FormControlLabel
                                        key={subItems.id}
                                        value={subItems.id}
                                        onChange={(event) =>
                                          multipleCheckboxHandler(
                                            event,
                                            index,
                                            i,
                                            items.type
                                          )
                                        }
                                        control={
                                          <Checkbox
                                            checked={
                                              parentStracture[pages][index][
                                                i
                                              ] != ""
                                                ? true
                                                : false
                                            }
                                            inputProps={{
                                              "aria-label": "controlled",
                                            }}
                                            size="small"
                                            sx={radioStyle}
                                          />
                                        }
                                        label={subItems.name}
                                      />
                                    ))}
                                  </FormGroup>
                                </FormControl>
                              </>
                            ) : items.type == "product_select_option" ? (
                              <>
                                <div className="grid grid-cols-1 gap-3">
                                  <FormControl
                                    fullWidth
                                    size="small"
                                    sx={selectStyle}
                                  >
                                    <InputLabel id={items.id}>
                                      {items.title}
                                    </InputLabel>
                                    <Select
                                      labelId={items.id}
                                      id={items.id}
                                      value={parentValues[pages][index]}
                                      label={items.title}
                                      onChange={(event) =>
                                        selectHandler(event, index, items.type)
                                      }
                                    >
                                      {items.items.map((subItems, i) => (
                                        <MenuItem
                                          key={subItems.id}
                                          value={subItems.id}
                                        >
                                          {subItems.name}
                                        </MenuItem>
                                      ))}
                                    </Select>
                                  </FormControl>
                                  {items.hint && (
                                    <div
                                      className="text-justify text-sm"
                                      dangerouslySetInnerHTML={{
                                        __html: items.hint,
                                      }}
                                    />
                                  )}
                                </div>
                              </>
                            ) : items.type == "checkbox_color" ? (
                              <div className="grid grid-cols-1 gap-3">
                                <div>
                                  {items.title && (
                                    <div className="text-sm mb-1">
                                      {items.title}
                                    </div>
                                  )}
                                  <div className="flex items-center gap-3">
                                    {items.items.map((subItems, i) => (
                                      <div key={subItems.id}>
                                        <input
                                          onClick={(event) =>
                                            multipleColorHandler(
                                              event,
                                              index,
                                              i,
                                              items.type
                                            )
                                          }
                                          type="checkbox"
                                          id={subItems.id}
                                          name="mutipleColor"
                                          value={subItems.id}
                                          className="hidden"
                                        ></input>
                                        <label
                                          htmlFor={subItems.id}
                                          className="w-5 h-5 rounded-sm border cursor-pointer flex items-center justify-center"
                                          style={{
                                            backgroundColor:
                                              subItems.color_code,
                                          }}
                                        >
                                          {subItems.id ==
                                            parentStracture[pages][index][
                                              i
                                            ] && (
                                            <CheckIcon
                                              fontSize="large"
                                              sx={{
                                                stroke: "#fff",
                                              }}
                                            />
                                          )}
                                        </label>
                                      </div>
                                    ))}
                                  </div>
                                </div>
                                {items.hint && (
                                  <div
                                    className="text-justify text-sm"
                                    dangerouslySetInnerHTML={{
                                      __html: items.hint,
                                    }}
                                  />
                                )}
                              </div>
                            ) : (
                              "test"
                            )}
                          </div>
                          {/* ****************child elements************************** */}
                          {pages != "start" &&
                            childStracture.length > 0 &&
                            childStracture[pages][index].map(
                              (childItem, childIndex) =>
                                childItem != "" && (
                                  <div key={childItem.id}>
                                    {childItem.children.item_type ==
                                    "simple_radio" ? (
                                      <FormControl>
                                        {childItem.children.title && (
                                          <FormLabel
                                            id={childItem.children.id}
                                            sx={labelStyle}
                                          >
                                            {childItem.children.title}
                                          </FormLabel>
                                        )}
                                        <RadioGroup
                                          onChange={(event) =>
                                            radioChildHandler(
                                              event,
                                              index,
                                              childIndex
                                            )
                                          }
                                          aria-labelledby={
                                            childItem.children.id
                                          }
                                          value={
                                            childValues[pages][index][
                                              childIndex
                                            ]
                                          }
                                          name={childItem.children.type}
                                        >
                                          {childItem.children.items.map(
                                            (subItems, i) => (
                                              <FormControlLabel
                                                key={subItems.id}
                                                value={subItems.id}
                                                name={i}
                                                control={
                                                  <Radio
                                                    size="small"
                                                    sx={radioStyle}
                                                  />
                                                }
                                                label={subItems.name}
                                              />
                                            )
                                          )}
                                        </RadioGroup>
                                        {childItem.children.hint && (
                                          <div className="text-xs text-red-700">
                                            {childItem.children.hint}
                                          </div>
                                        )}
                                      </FormControl>
                                    ) : childItem.children.item_type ==
                                      "simple_text" ? (
                                      <div className="grid grid-cols-1 gap-3">
                                        {childItem.children.title && (
                                          <div>{childItem.children.title}</div>
                                        )}

                                        {childItem.children.items.map(
                                          (subItems, i) => (
                                            <TextField
                                              sx={inputTextStyle}
                                              focused
                                              key={subItems.id}
                                              size="small"
                                              id={subItems.id}
                                              label={subItems.name}
                                              variant="outlined"
                                              type={
                                                subItems.input_type
                                                  ? subItems.input_type
                                                  : "text"
                                              }
                                            />
                                          )
                                        )}

                                        {childItem.children.hint && (
                                          <div className="text-xs text-red-700">
                                            {childItem.children.hint}
                                          </div>
                                        )}
                                      </div>
                                    ) : childItem.children.item_type ==
                                      "simple_select_option" ? (
                                      <div className="grid grid-cols-1 gap-3">
                                        <FormControl
                                          fullWidth
                                          size="small"
                                          sx={selectStyle}
                                        >
                                          <InputLabel
                                            id={childItem.children.id}
                                          >
                                            {childItem.children.title}
                                          </InputLabel>
                                          <Select
                                            labelId={childItem.children.id}
                                            id={childItem.children.id}
                                            value={
                                              childValues[pages][index][
                                                childIndex
                                              ]
                                            }
                                            label={childItem.children.title}
                                            onChange={(event) =>
                                              selectChildrenHandler(
                                                event,
                                                index,
                                                childIndex
                                              )
                                            }
                                          >
                                            {childItem.children.items.map(
                                              (subItems) => (
                                                <MenuItem
                                                  key={subItems.id}
                                                  value={subItems.id}
                                                >
                                                  {subItems.name}
                                                </MenuItem>
                                              )
                                            )}
                                          </Select>
                                        </FormControl>
                                        {childItem.hint && (
                                          <div
                                            className="text-justify text-sm"
                                            dangerouslySetInnerHTML={{
                                              __html: childItem.hint,
                                            }}
                                          />
                                        )}
                                      </div>
                                    ) : childItem.children.item_type ==
                                      "radio_color" ? (
                                      <div className="grid grid-cols-1 gap-3">
                                        <div>
                                          {childItem.children.title && (
                                            <div className="text-sm mb-1">
                                              {childItem.children.title}
                                            </div>
                                          )}
                                          <div className="flex items-center gap-3">
                                            {childItem.children.items.map(
                                              (subItems, i) => (
                                                <div
                                                  onClick={() =>
                                                    colorChildHandler(
                                                      subItems.id,
                                                      index,
                                                      childIndex
                                                    )
                                                  }
                                                  key={subItems.id}
                                                  className="w-5 h-5 rounded-sm border cursor-pointer flex items-center justify-center"
                                                  style={{
                                                    backgroundColor:
                                                      subItems.color_code,
                                                  }}
                                                >
                                                  {subItems.id ==
                                                    childValues[pages][index][
                                                      childIndex
                                                    ] && (
                                                    <CheckIcon
                                                      fontSize="large"
                                                      sx={{
                                                        stroke: "#fff",
                                                      }}
                                                    />
                                                  )}
                                                </div>
                                              )
                                            )}
                                          </div>
                                        </div>
                                        {childItem.children.hint && (
                                          <div
                                            className="text-justify text-sm"
                                            dangerouslySetInnerHTML={{
                                              __html: childItem.children.hint,
                                            }}
                                          />
                                        )}
                                      </div>
                                    ) : childItem.children.item_type ==
                                      "simple_checkbox" ? (
                                      <FormControl
                                        component="div"
                                        variant="standard"
                                      >
                                        {childItem.children.title && (
                                          <FormLabel
                                            component="legend"
                                            sx={labelStyle}
                                          >
                                            {childItem.children.title}
                                          </FormLabel>
                                        )}
                                        <FormGroup>
                                          {childItem.children.items.map(
                                            (subItems, i) => {
                                              return (
                                                <FormControlLabel
                                                  onChange={(event) =>
                                                    checkboxChildHandler(
                                                      event,
                                                      index,
                                                      childIndex,
                                                      i
                                                    )
                                                  }
                                                  checked={
                                                    multipleChildCheckbox[
                                                      pages
                                                    ][index][childIndex][i] !=
                                                    ""
                                                      ? true
                                                      : false
                                                  }
                                                  key={subItems.id}
                                                  control={
                                                    <Checkbox
                                                      size="small"
                                                      sx={radioStyle}
                                                      value={subItems.id}
                                                    />
                                                  }
                                                  label={subItems.name}
                                                />
                                              );
                                            }
                                          )}
                                        </FormGroup>
                                      </FormControl>
                                    ) : childItem.children.item_type ==
                                      "product_radio" ? (
                                      <>
                                        <FormControl>
                                          {childItem.children.title && (
                                            <FormLabel
                                              id={childItem.children.id}
                                              sx={labelStyle}
                                            >
                                              {childItem.children.title}
                                            </FormLabel>
                                          )}
                                          <RadioGroup
                                            onChange={(event) =>
                                              radioChildHandler(
                                                event,
                                                index,
                                                childIndex
                                              )
                                            }
                                            aria-labelledby={items.id}
                                            value={
                                              childValues[pages][index][
                                                childIndex
                                              ]
                                            }
                                            name={items.type}
                                          >
                                            {childItem.children.items.map(
                                              (subItems, i) => (
                                                <FormControlLabel
                                                  key={subItems.id}
                                                  value={subItems.id}
                                                  name={i}
                                                  control={
                                                    <Radio
                                                      size="small"
                                                      sx={radioStyle}
                                                    />
                                                  }
                                                  label={subItems.name}
                                                />
                                              )
                                            )}
                                          </RadioGroup>
                                          {childItem.children.hint && (
                                            <div className="text-xs text-red-700">
                                              {childItem.children.hint}
                                            </div>
                                          )}
                                        </FormControl>
                                      </>
                                    ) : childItem.children.item_type ==
                                      "product_checkbox" ? (
                                      <>
                                        <FormControl
                                          component="div"
                                          variant="standard"
                                        >
                                          {childItem.children.title && (
                                            <FormLabel
                                              component="legend"
                                              sx={labelStyle}
                                            >
                                              {childItem.children.title}
                                            </FormLabel>
                                          )}
                                          <FormGroup>
                                            {childItem.children.items.map(
                                              (subItems, i) => (
                                                <FormControlLabel
                                                  onChange={(event) =>
                                                    checkboxChildHandler(
                                                      event,
                                                      index,
                                                      childIndex,
                                                      i
                                                    )
                                                  }
                                                  checked={
                                                    multipleChildCheckbox[
                                                      pages
                                                    ][index][childIndex][i] !=
                                                    ""
                                                      ? true
                                                      : false
                                                  }
                                                  key={subItems.id}
                                                  control={
                                                    <Checkbox
                                                      size="small"
                                                      sx={radioStyle}
                                                      value={subItems.id}
                                                    />
                                                  }
                                                  label={subItems.name}
                                                />
                                              )
                                            )}
                                          </FormGroup>
                                        </FormControl>
                                      </>
                                    ) : childItem.children.item_type ==
                                      "product_select_option" ? (
                                      <>
                                        <div className="grid grid-cols-1 gap-3">
                                          <FormControl
                                            fullWidth
                                            size="small"
                                            sx={selectStyle}
                                          >
                                            <InputLabel
                                              id={childItem.children.id}
                                            >
                                              {childItem.children.title}
                                            </InputLabel>
                                            <Select
                                              labelId={childItem.children.id}
                                              id={childItem.children.id}
                                              value={
                                                childValues[pages][index][
                                                  childIndex
                                                ]
                                              }
                                              label={childItem.children.title}
                                              onChange={(event) =>
                                                selectChildrenHandler(
                                                  event,
                                                  index,
                                                  childIndex
                                                )
                                              }
                                            >
                                              {childItem.children.items.map(
                                                (subItems, i) => (
                                                  <MenuItem
                                                    key={subItems.id}
                                                    value={subItems.id}
                                                  >
                                                    {subItems.name}
                                                  </MenuItem>
                                                )
                                              )}
                                            </Select>
                                          </FormControl>
                                          {childItem.children.hint && (
                                            <div
                                              className="text-justify text-sm"
                                              dangerouslySetInnerHTML={{
                                                __html: childItem.children.hint,
                                              }}
                                            />
                                          )}
                                        </div>
                                      </>
                                    ) : childItem.children.item_type ==
                                      "checkbox_color" ? (
                                      <div className="grid grid-cols-1 gap-3">
                                        <div>
                                          {childItem.children.title && (
                                            <div className="text-sm mb-1">
                                              {childItem.children.title}
                                            </div>
                                          )}
                                          <div className="flex items-center gap-3">
                                            {childItem.children.items.map(
                                              (subItems, i) => (
                                                <div key={subItems.id}>
                                                  <input
                                                    onClick={(event) =>
                                                      multipleChildColorHandler(
                                                        event,
                                                        index,
                                                        childIndex,
                                                        i
                                                      )
                                                    }
                                                    type="checkbox"
                                                    id={subItems.id}
                                                    name="mutipleColor"
                                                    value={subItems.id}
                                                    className="hidden"
                                                  ></input>
                                                  <label
                                                    htmlFor={subItems.id}
                                                    className="w-5 h-5 rounded-sm border cursor-pointer flex items-center justify-center"
                                                    style={{
                                                      backgroundColor:
                                                        subItems.color_code,
                                                    }}
                                                  >
                                                    {subItems.id ==
                                                      multipleChildCheckbox[
                                                        pages
                                                      ][index][childIndex][
                                                        i
                                                      ] && (
                                                      <CheckIcon
                                                        fontSize="large"
                                                        sx={{
                                                          stroke: "#fff",
                                                        }}
                                                      />
                                                    )}
                                                  </label>
                                                </div>
                                              )
                                            )}
                                          </div>
                                        </div>
                                        {childItem.children.hint && (
                                          <div
                                            className="text-justify text-sm"
                                            dangerouslySetInnerHTML={{
                                              __html: childItem.children.hint,
                                            }}
                                          />
                                        )}
                                      </div>
                                    ) : (
                                      "test"
                                    )}
                                  </div>
                                )
                            )}
                        </Fragment>
                      ))}
                  </div>
                )}

                {imageStracture[pages] && imageStracture[pages].image && (
                  <div
                    className={`${
                      groups && groups[pages].layout_type == "row"
                        ? "col-start-3"
                        : "col-start-2"
                    }`}
                  >
                    <ImageCustom
                      size="original"
                      data={imageStracture[pages].image}
                      alt={imageStracture[pages].image_alt}
                      title={imageStracture[pages].image_alt}
                      fullWidth={false}
                      width={500}
                      height={140}
                      style={{width:'78%'}}
                    />
                  </div>
                )}
              </div>

              {/* buttons */}
              <div className="flex justify-center gap-4 col-span-3">
                {pages == pageLength ? (
                  toCall[pages] ? (
                    <ButtonCustom
                      text="تماس بگیرید"
                      title="تماس بگیرید"
                      textColor={data.btn_inner_color}
                      color={data.btn_color}
                      onClick={()=>setPages("support")}
                    />
                  ) : (
                    <ButtonCustom
                      text={data.end}
                      title={data.end}
                      textColor={data.btn_inner_color}
                      color={data.btn_color}
                    />
                  )
                ) : toCall[pages] ? (
                  <ButtonCustom
                    id={groups ? `step_${groups[pages].step}` : "#"}
                    text="تماس بگیرید"
                    title="تماس بگیرید"
                    textColor={data.btn_inner_color}
                    color={data.btn_color}
                    disabled={disabledButton}
                    onClick={()=>setPages("support")}
                  />
                ) : (
                  <ButtonCustom
                    id={groups ? `step_${groups[pages].step}` : "#"}
                    text="مرحله بعد"
                    title="مرحله بعد"
                    textColor={data.btn_inner_color}
                    color={data.btn_color}
                    onClick={nextHandler}
                    disabled={disabledButton}
                  />
                )}
                <ButtonCustom
                  text="مرحله قبل"
                  title="مرحله قبل"
                  color="#808080"
                  onClick={prevHandler}
                />
              </div>
              {/* buttons */}
            </div>
          )}
        </div>
        {/* body */}
      </div>

      {/* <script
        type="text/javascript"
        dangerouslySetInnerHTML={{ __html: data.form_script }}
      /> */}
    </>
  );
}
