"use client";
import * as React from "react";
import Box from "@mui/material/Box";
import Drawer from "@mui/material/Drawer";
import Button from "@mui/material/Button";
import List from "@mui/material/List";
import Divider from "@mui/material/Divider";
import ListItem from "@mui/material/ListItem";
import ListItemButton from "@mui/material/ListItemButton";
import ListItemIcon from "@mui/material/ListItemIcon";
import ListItemText from "@mui/material/ListItemText";
import InboxIcon from "@mui/icons-material/MoveToInbox";
import MailIcon from "@mui/icons-material/Mail";
import ButtonCustom from "./ButtonCustom";
import { Swiper, SwiperSlide } from "swiper/react";
import  LocalShippingIcon from "@mui/icons-material/LocalShipping"
import  CreditScoreIcon from "@mui/icons-material/CreditScore"
import  SupportAgentIcon from "@mui/icons-material/SupportAgent"
import  CurrencyExchangeIcon from "@mui/icons-material/CurrencyExchange"
import CloseIcon from "@mui/icons-material/Close";
import IconButton from "@mui/material/IconButton";

import "swiper/css";

export default function FloatingStatus({ open, close }) {
 
  return (
    <div>
      <Drawer anchor={"bottom"} open={open} onClose={close}>
        {/* {DrawerList} */}
        <div className="py-3 px-2">
          <div className="flex justify-center mb-6">
            <div className="w-28 h-1 bg-[#a4a4a4] rounded-lg"></div>
          </div>

          <div className="flex justify-between items-center mb-4">
            <div className="text-sm font-bold">
              محصول شما به سبد خرید افزوده شد
            </div>
            <IconButton size="small" onClick={close}>
                <CloseIcon />
              </IconButton>
          </div>

          <div className="mb-4 py-2 border-b border-t">
            <Swiper slidesPerView={1.5} className="mySwiper">
              <SwiperSlide>
              <div className="flex gap-2 lg:flex-row lg:justify-center lg:items-start items-center text-[#838383]">
                  <LocalShippingIcon />
                  <p className="lg:mr-2 lg:mt-0lg:text-base text-xs lg:text-right text-center">
                    ارسال سریع به سراسر ایران
                  </p>
                </div>
              </SwiperSlide>
              <SwiperSlide>
              <div className="flex gap-2 lg:flex-row lg:justify-center lg:items-start items-center text-[#838383]">
                  <CurrencyExchangeIcon />
                  <p className="lg:mr-2 lg:mt-0 lg:text-base text-xs lg:text-right text-center">
                    تضمین بازگشت وجه
                  </p>
                </div>
              </SwiperSlide>
              <SwiperSlide>
              <div className="flex gap-2 lg:flex-row lg:justify-center lg:items-start items-center text-[#838383]">
                  <CreditScoreIcon />
                  <p className="lg:mr-2 lg:mt-0 lg:text-base text-xs lg:text-right text-center">
                    تنوع در روش های پرداخت
                  </p>
                </div>
              </SwiperSlide>
              <SwiperSlide>
              <div className="flex gap-2 lg:flex-row lg:justify-center lg:items-start items-center text-[#838383]">
                  <SupportAgentIcon />
                  <p className="lg:mr-2 lg:mt-0 lg:text-base text-xs lg:text-right text-center">
                    پشتیبانی حین و بعد از فروش
                  </p>
                </div>
              </SwiperSlide>
            </Swiper>
          </div>

          <ButtonCustom 
          text="سبد خرید" 
          title="سبد خرید" 
          fullWidth={true} 
          link="/cart" />
        </div>
      </Drawer>
    </div>
  );
}
