"use client";
import React, { useContext, useState } from "react";
import useMediaQuery from "@mui/material/useMediaQuery";
import ButtonCustom from "./ButtonCustom";
import IconButton from "@mui/material/IconButton";
import KeyboardArrowDownIcon from "@mui/icons-material/KeyboardArrowDown";
import KeyboardArrowUpIcon from "@mui/icons-material/KeyboardArrowUp";
import { SettingApi } from "@/context/api/Setting";

export default function AboutUs(params) {
  const mobile = useMediaQuery("(max-width : 540px)");
  const [show, setShow] = useState(false);
  const { dataSetting } = useContext(SettingApi);
  return (
    <section
      className=" rounded-lg"
      style={{
        maxWidth: "1358px",
        margin: "1rem auto",
        backgroundColor: "#f7f7f7",
        padding: "1rem 1.5rem",
      }}
    >
      <h1 className="my-4 sm:text-2xl text-lg">{dataSetting && dataSetting.data.data.setting.name}</h1>
      {!mobile ? (
        <p
        dangerouslySetInnerHTML={{ __html: dataSetting && dataSetting.data.data.setting.footer.about_us }}
        className="text-justify text-[#747272]"
      />
      ) : (
        <div className="text-justify text-[#747272]">
           <p
        dangerouslySetInnerHTML={{ __html: dataSetting && dataSetting.data.data.setting.footer.about_us_mobile }}
        className="text-justify text-[#747272]"
      />
        </div>
      )}
    </section>
  );
}
