"use client";
import React, { useState } from "react";
import StickyBox from "react-sticky-box";
import BannerCarousel from "../constantElements/BannerCarousel";
import Filter from "../constantElements/Filter";
import useMediaQuery from "@mui/material/useMediaQuery";
import { Swiper, SwiperSlide } from "swiper/react";
import { Grid, Pagination , Autoplay } from "swiper/modules";

import "swiper/css";
import "swiper/css/grid";
import "swiper/css/pagination";
import "@/styles/styles.css";
import Link from "next/link";
import ImageCustom from "../constantElements/ImageCustom";
import styles from "@/assets/css/ProductCard.module.css";

const style = {
  "--swiper-navigation-color": "var(--theme-color)",
  "--swiper-pagination-color": "var(--theme-color)",
};

//Components

const SideBar = ({
  className,
  sideBanner = [],
  filters = [],
  type,
  popularData = [],
  id,
  sendData,
  scrollTo,
  currentSlug,
  testValue
}) => {


  
  

  const mobile = useMediaQuery("(max-width:540px)");

  const [packageExpanded, setPackageExpanded] = useState(true);

  const packageHandler = () => {
    setPackageExpanded(!packageExpanded);
  };

  return (
    <div className={`${className} h-auto relative z-20`}>
      <StickyBox offsetTop={70} offsetBottom={2}>
        <section className="grid grid-cols-1 gap-4">
          {filters.length > 0 ? (
            type != "brand" ? (
              <div
                className={`filter w-full h-auto bg-[#A4A4A4] rounded-lg flex flex-col items-center justify-between `}
              >
                <h3 className={`text-white my-1`}>فیلتر محصولات</h3>
                <div
                  className={`content h-auto bg-white w-full border border-[#A4A4A4] rounded-lg p-2 min-h-[420px] relative`}
                >
                  <Filter
                  testValue={testValue}
                    filters={filters}
                    id={id}
                    sendData={sendData}
                    scrollTo={scrollTo}
                    currentSlug={currentSlug}
                  />
                </div>
              </div>
            ) : (
              <div
                className={`filter w-full h-auto bg-[#A4A4A4] rounded-lg flex flex-col items-center justify-between `}
              >
                <h3 className={`text-white my-1`}>فیلتر محصولات</h3>
                <div
                  className={`content h-auto bg-white w-full border border-[#A4A4A4] rounded-lg p-2`}
                >
                  <Filter
                  testValue={testValue}
                    filters={filters}
                    id={id}
                    sendData={sendData}
                    scrollTo={scrollTo}
                    type={type}
                  />
                </div>
              </div>
            )
          ) : null}

          {/*  filters  */}

          {/*    banner    */}
          {sideBanner.length > 0 && !mobile ? (
            <BannerCarousel
              data={sideBanner}
              className="mb-0"
              autoplayDelay={3500}
            />
          ) : null}
          {/*    banner    */}

          {popularData && popularData.length > 0 && !mobile ? (
            <div
              className={`filter w-full h-auto bg-theme rounded-lg flex flex-col items-center justify-between `}
            >
              <h3 className={`text-white my-1`}>محبوب ترینها</h3>
              <div
                className={`content h-auto bg-white w-full border border-theme rounded-lg p-2`}
              >
                {/* <SwiperCarousel type="asideCarousel" data={popularData} /> */}
                <Swiper
                autoplay={{
                  enabled : true,
                  delay:2500,
                  pauseOnMouseEnter:true
              }}
                  slidesPerView={1}
                  grid={{
                    rows: 4,
                    fill: null,
                  }}
                  spaceBetween={5}
                  style={style}
                  pagination={{
                    clickable: true,
                  }}
                  modules={[Grid, Pagination ,Autoplay]}
                  className="mySwiper_popular"
                >
                  {popularData.map((items) => (
                    <SwiperSlide key={items.id}>
                      <Link
                        href={`/${items.slug}`}
                        title={items.alt_name}
                        className="grid grid-cols-3 gap-2 items-center border-b pb-2 text"
                      >
                        <ImageCustom
                          data={items.image}
                          alt={items.image_alt}
                          title={items.image_alt}
                          // props
                          loading={"lazy"}
                          width={83}
                          height={83}
                          fullWidth={true}
                        />
                        <div className={`${styles.truncate} col-span-2 text-sm`}>
                          {items.name}
                        </div>
                      </Link>
                    </SwiperSlide>
                  ))}
                </Swiper>
              </div>
            </div>
          ) : null}
        </section>
      </StickyBox>
    </div>
  );
};

export default SideBar;
