import Package from "@/components/packages/Package";
import BreadcrumbCustom from "@/components/constantElements/BreadcrumbCustom";

import axios from "@/lib/axios";

const frontUrl = process.env.NEXT_PUBLIC_FRONTEND_URL;
const backendUrlImage = process.env.NEXT_PUBLIC_BACKEND_URL_IMAGE;
const backendUrl = process.env.NEXT_PUBLIC_BACKEND_URL;

export async function generateMetadata({ params, searchParams }) {
  let video = false;
  const newSearchParams = new URLSearchParams(searchParams).toString();
  const dataFetch = await axios
    .get(searchParams ? `api/packages?${newSearchParams}` : `api/packages`)
    .then((res) => res);

  const next =
  dataFetch.data.products&&
    dataFetch.data.products.next_page_url &&
    dataFetch.data.products.next_page_url.replace(
      `${backendUrl}/api/`,
      frontUrl
    );
  const prev =
  dataFetch.data.products&&
    dataFetch.data.products.prev_page_url &&
    dataFetch.data.products.prev_page_url.replace(
      `${backendUrl}/api/`,
      frontUrl
    );

  if (dataFetch.data.products && !Array.isArray(dataFetch.data.products)) {
    dataFetch.data.products.data.map((e) => {
      if (e && e.video) {
        video = true;
      }
    });
  }

  return {
    ...(video
      ? dataFetch.data.products
        ? dataFetch.data.products.next_page_url &&
          dataFetch.data.products.prev_page_url
          ? {
              icons: {
                other: [
                  {
                    rel: "next",
                    url: `${next}`,
                  },
                  {
                    rel: "prev",
                    url: `${prev}`,
                  },
                  {
                    rel: "preconnect",
                    url: "https://upload.vidbeen.ir",
                  },
                  {
                    rel: "dns-prefetch",
                    url: "https://upload.vidbeen.ir",
                  },
                  {
                    rel: "preconnect",
                    url: backendUrl,
                  },
                ],
              },
            }
          : dataFetch.data.products.prev_page_url &&
            !dataFetch.data.products.next_page_url
          ? {
              icons: {
                other: [
                  {
                    rel: "prev",
                    url: `${prev}`,
                  },
                  {
                    rel: "preconnect",
                    url: "https://upload.vidbeen.ir",
                  },
                  {
                    rel: "dns-prefetch",
                    url: "https://upload.vidbeen.ir",
                  },
                  {
                    rel: "preconnect",
                    url: backendUrl,
                  },
                ],
              },
            }
          : dataFetch.data.products.next_page_url &&
            !dataFetch.data.products.prev_page_url
          ? {
              icons: {
                other: [
                  {
                    rel: "next",
                    url: `${next}`,
                  },
                  {
                    rel: "preconnect",
                    url: "https://upload.vidbeen.ir",
                  },
                  {
                    rel: "dns-prefetch",
                    url: "https://upload.vidbeen.ir",
                  },
                  {
                    rel: "preconnect",
                    url: backendUrl,
                  },
                ],
              },
            }
          : {
              icons: {
                other: [
                  {
                    rel: "preconnect",
                    url: "https://upload.vidbeen.ir",
                  },
                  {
                    rel: "dns-prefetch",
                    url: "https://upload.vidbeen.ir",
                  },
                  {
                    rel: "preconnect",
                    url: backendUrl,
                  },
                ],
              },
            }
        : {
            icons: {
              other: [
                {
                  rel: "preconnect",
                  url: "https://upload.vidbeen.ir",
                },
                {
                  rel: "dns-prefetch",
                  url: "https://upload.vidbeen.ir",
                },
                {
                  rel: "preconnect",
                  url: backendUrl,
                },
              ],
            },
          }
      : dataFetch.data.products
      ? dataFetch.data.products.next_page_url &&
        dataFetch.data.products.prev_page_url
        ? {
            icons: {
              other: [
                {
                  rel: "next",
                  url: `${next}`,
                },
                {
                  rel: "prev",
                  url: `${prev}`,
                },
                {
                  rel: "preconnect",
                  url: backendUrl,
                },
              ],
            },
          }
        : dataFetch.data.products.prev_page_url &&
          !dataFetch.data.products.next_page_url
        ? {
            icons: {
              other: [
                {
                  rel: "prev",
                  url: `${prev}`,
                },
                {
                  rel: "preconnect",
                  url: backendUrl,
                },
              ],
            },
          }
        : dataFetch.data.products.next_page_url &&
          !dataFetch.data.products.prev_page_url
        ? {
            icons: {
              other: [
                {
                  rel: "next",
                  url: `${next}`,
                },
                {
                  rel: "preconnect",
                  url: backendUrl,
                },
              ],
            },
          }
        : {
            icons: {
              other: [
                {
                  rel: "preconnect",
                  url: backendUrl,
                },
              ],
            },
          }
      : null),
  };
}

export default async function Page({ params, searchParams }) {
  let values = Object.values(searchParams)
  values.splice(values.length - 1 , 1)
  
  
  
  
  const newSearchParams = new URLSearchParams(searchParams).toString();
  const pageData = await axios
    .get(searchParams ? `api/packages?${newSearchParams}` : `api/packages`)
    .then((res) => res);

  return (
    <>
      <BreadcrumbCustom
        parentId={null}
        categorySlug={null}
        categoryName={"پکیج ها"}
        structure={null}
        uniqueSlug={"/packages"}
      />

      <Package
        testValue = {values}
        apiData={pageData.data}
        pages={searchParams.page}
        scrollTo={newSearchParams}
      />
    </>
  );
}
