"use client";
import React, { Fragment, useState } from "react";
import { useMediaQuery } from "@mui/material";
import Pagination from "../category/Pagination";

//css
import styles from "@/assets/css/category/MainCategory.module.css";
//css


//components
import Title from "@/components/main/Title";
import Card from '../Card'
import ViewListIcon from '@mui/icons-material/ViewList';
import ViewModuleIcon from '@mui/icons-material/ViewModule';
import ToggleButtonIcon from '@mui/material/ToggleButton';
import InputLabel from '@mui/material/InputLabel';
import FormControl from '@mui/material/FormControl';
import NativeSelect from '@mui/material/NativeSelect'
import Box from '@mui/material/Box';
import ToggleButtonGroup from '@mui/material/ToggleButtonGroup';
import SubCategory from "../category/SubCategory";
import Description from '@/components/category/Description'
import dynamic from "next/dynamic";
import Skeleton from "@mui/material/Skeleton";
import Filters from "../menu/mobile/Filters";
import CardContainer from "../constantElements/CardContainer";
//components


const overRide = () => ({
    display: "block",
    margin: "0 auto",
});



const Filter = dynamic(() => import("@/components/constantElements/Filter"), {
    ssr: false,
    loading: () => (
        <div className="w-[150px] h-[45px] sm:col-span-1">
            <Skeleton
                variant="rectangular"
                sx={{ width: "100%" }}
                height={45}
                animation="wave"
            />
        </div>
    ),
});



const SideBar = dynamic(() => import("@/components/category/SideBar"), {
    ssr: false,
    loading: () => (
        <div className="col-span-2 xl:block hidden w-full h-screen">
            <Skeleton
                variant="rectangular"
                sx={{ width: "100%" }}
                height={628}
                animation="wave"
            />
        </div>
    ),
});






const PackageItem = ({ apiData, slug, pages, scrollTo , testValue}) => {

    const [filters, setFilters] = useState(false)
    const [list, setList] = useState(false)
    const [filterData, setFilterData] = useState(null)
    // slug = slug.replace('api/', '')
    const [view, setView] = useState(`module`);
    const mobile = useMediaQuery("(max-width : 540px)");
    const tablet = useMediaQuery("(max-width:1280px)");
    const handleChange = (event, nextView) => {
        if (nextView !== null) setView(nextView);
        setList(nextView == 'list' ? true : false)
    };



    const data = (data) => {
        if (apiData.products.total == data.data.products.total) {
            setFilterData(null);
        } else {
            setFilterData(data)
        }

    }






    return (
        <main className={`flex flex-col items-center ${styles.mainContainer}`}>

            <Title position="head" titleValue={apiData && apiData.title} />
            <section
                className={`grid grid-flow-row grid-cols-9 sm:px-4 px-2 py-4 gap-4 w-full  max-with-unique`}
            >
                {/* Aside Of Category */}
                <SideBar
                    className="col-span-2 xl:block hidden"
                    type='brand'
                    testValue={testValue}
                    sideBanner={apiData.side_banners}
                    filters={apiData.filters}
                    popularData={apiData.popular_sliders}
                    sendData={data}
                    scrollTo={scrollTo}
                    id={apiData.id}
                />
                {/* Aside Of Category */}
                <section className="sm:col-span-7 col-span-9">
                    {
                        apiData &&
                        apiData.children.length > 0 &&
                        <section className="grid sm:grid-cols-5 gap-4 grid-cols-2 mb-12">
                            {apiData && apiData.children.map(subCategory => (
                                <Fragment key={subCategory.id}>
                                    <SubCategory
                                        slug={subCategory.slug}
                                        name={subCategory.name}
                                        type='package'
                                    />
                                </Fragment>
                            ))}

                        </section>
                    }

                    {/* cards */}
                    <CardContainer
                        apiData={apiData}
                        pages={pages}
                        scrollTo={scrollTo}
                    // currentSlug={currentSlug}
                    type='packageItem'
                    />

                    {apiData && apiData.body ?
                        <Description type="default" body={apiData && apiData.body} />
                        :
                        null
                    }
                </section>
            </section>
        </main>
    );
};

export default PackageItem;