import styles from "../assets/css/head/Navbar.module.css";
import Link from "next/link";


const Navbar = ({ data }) => {


  return (
    <>
      <nav className="relative">
        <div
          className={`${styles.container} w-full bg-[#F3F3F3] px-4 py-3 shadow sm:flex justify-center hidden mt-1`}
        >
          {data.page_menu.top_menu.length > 0 && (
            <ul
              className={`flex items-center gap-8`}
              style={{ maxWidth: "1358px" }}
            >
              {data.page_menu.top_menu.map((navitems) => (
                <li key={navitems.id}>
                  <Link
                    rel="preload"
                    prefetch
                    title={navitems.name}
                    href={`/${navitems.url}`}
                    className="flex items-center gap-2"
                  >
                    {/* {client ? (
                      <DiscountIcon />
                    ) : (
                      <div className="w-6 h-6">
                        <Skeleton
                          variant="circular"
                          sx={{ width: "100%", height: "100%" }}
                          animation="pulse"
                        />
                      </div>
                    )} */}

                    <div className="text-sm">{navitems.name}</div>
                  </Link>
                </li>
              ))}

              <li>
                
                <Link
                 prefetch
                  target="_blank"
                  rel="preload"
                  title={"مجله آموزشی"}
                  href={"https://mag.dcakala.com/"}
                  className="flex items-center gap-2"
                >
                  {/* {client ? (
                      <DiscountIcon />
                    ) : (
                      <div className="w-6 h-6">
                        <Skeleton
                          variant="circular"
                          sx={{ width: "100%", height: "100%" }}
                          animation="pulse"
                        />
                      </div>
                    )} */}
                  <div className="text-sm">مجله آموزشی</div>
                </Link>
              </li>
            </ul>
          )}
        </div>
      </nav>
    </>
  );
};

export default Navbar;
