import Header from "@/layouts/Header";
import Navbar from "@/components/Navbar";
import Footer from "@/layouts/Footer";




const backendUrl = process.env.NEXT_PUBLIC_BACKEND_URL
const appUrl = process.env.NEXT_PUBLIC_FRONTEND_URL;
export default async function Layout({ children }) {
  const data = await fetch(`${backendUrl}/api/boot-setting-api` , {cache:"no-store", headers:{'domain-name' : appUrl}})
  const menu = await fetch(`${backendUrl}/api/boot-menu-api` , {cache:"no-store", headers:{'domain-name' : appUrl}})
  const settingValues = await data.json()
  const menuData = await menu.json()

  
  return (
    <>
      <Header menuData={menuData} />
      <Navbar data={settingValues.data}/>
      {children}
      <Footer data={settingValues.data} />
    </>
  );
}
