'use client'
import React, { useState } from "react";
import { styled } from "@mui/material/styles";
import NavigateBeforeIcon from "@mui/icons-material/NavigateBefore";
import MuiAccordion from "@mui/material/Accordion";
import MuiAccordionSummary from "@mui/material/AccordionSummary";
import MuiAccordionDetails from "@mui/material/AccordionDetails";
import Typography from "@mui/material/Typography";
import Image from "next/image";
import Link from "next/link";
import imageAccordion from "../../public/images/Banners/bannerRight.jpg";
import ImageCustom from "./constantElements/ImageCustom";
import ExpandMoreIcon from '@mui/icons-material/ExpandMore';
import TabCustom from "./constantElements/TabCustom";
import HelpIcon from '@mui/icons-material/Help';

const Accordion = styled((props) => (
  <MuiAccordion disableGutters elevation={0} square {...props} />
))(({ theme }) => ({
  border: `1px solid #666`,
  borderRadius: "15px",
  width: "100%",
  // marginTop: "14px",
  
  // marginBottom: ".5rem",
  position: "relative",
  "&:not(:last-child)": {
    borderBottom: 0,
  },
  "&.MuiAccordion-root.Mui-expanded:last-of-type": {
    marginBottom: ".5rem",
  },
  "&:before": {
    display: "none",
  },
}));

const AccordionSummary = styled((props) => (
  <MuiAccordionSummary
    expandIcon={<ExpandMoreIcon fontSize="large" sx={{color:'#666'}} />}
    {...props}
  />
))(({ theme }) => ({
  backgroundColor:
    theme.palette.mode === "dark" ? "rgba(255, 255, 255, .05)" : "none",
  flexDirection: "row",
  
  "& .MuiAccordionSummary-content": {
    marginLeft: theme.spacing(1),
  },
  "@media (max-width: 540px)": {
    paddingLeft: "1.5rem",
  },
}));

const AccordionDetails = styled(MuiAccordionDetails)(({ theme }) => ({
  padding: theme.spacing(2),
  textAlign: "justify",
  display: "flex",
  "@media (max-width: 540px)": {
    flexDirection: "column",
    alignItems: "center",
  },
}));

export default function Accordions({ type, faqData, data = [] ,title = null , classWidth = false , dataStructure = false , ...props }) {
  
  const backendUrl = process.env.NEXT_PUBLIC_BACKEND_URL_IMAGE;
  const [expanded, setExpanded] = useState(0);

  const handleChange = (i) => {
    if (i == expanded) {
      setExpanded(null);
    } else {
      setExpanded(i);
    }
  };

  // function stripHtml(html) { var temporalDivElement = document.createElement("div"); temporalDivElement.innerHTML = html; return temporalDivElement.textContent || temporalDivElement.innerText || ""; }

  function stripHtml(html , key) { if (typeof window !== "undefined" && typeof document !== "undefined") { var temporalDivElement = document.createElement("div"); temporalDivElement.setAttribute('key' , key); temporalDivElement.innerHTML = html; return temporalDivElement.textContent || temporalDivElement.innerText || ""; } return ""; 
}


  const jsonLd = {
    "@context": "https://schema.org",
    "@type": "FAQPage",
    mainEntity: faqData.length > 0 ? faqData.map(faq => ({
      
      "@type": "Question",
      name: stripHtml(faq.question),
      acceptedAnswer: {
        "@type": "Answer",
        text: stripHtml(faq.answer)
      }
    })) : []
  };
  
  return (
    <div className={`mb-12 ${classWidth && 'mx-auto max-with-unique'} `}>
      {type === "photoContent" ? (
        <>
        {/* <TabCustom className="mb-8" bold={true} value={["محتوای عکس دار"]} /> */}
          {/* accordion 1 */}
          <section className="grid gap-4">
          {data.length > 0 &&
            data.map((accordion, i) => (
              <div
                key={accordion.id}
                className="w-full h-fit flex justify-end last:mb-5"
              >
                <div className="rounded-xl"></div>
                <Accordion
                  expanded={i == expanded ? true : false}
                  onChange={() => handleChange(i)}
                  sx={{boxShadow:   i == 0 ? "0 -15px 0 0 var(--theme-color), 0 0 5px 2px #dddddda3" : "unset"}}
                >
                  <AccordionSummary
                    aria-controls="panel1d-content"
                    id="panel1d-header"
                  >
                    <Typography>{accordion.title}</Typography>
                  </AccordionSummary>
                  <AccordionDetails>
                    <section className="sm:w-1/4 w-full sm:ml-4 ml-0 sm:mb-0 mb-2">
                      <ImageCustom
                        data={accordion.image}
                        alt={accordion.image_alt}
                        title={accordion.image_alt}
                        // props
                        loading={"lazy"}
                        width={350}
                        height={400}
                        size = 'original'
                      />
                    </section>
                    <section className="sm:w-3/4 w-full ckeditor">
                      <section
                        className="w-full ckeditor"
                        dangerouslySetInnerHTML={{
                          __html: accordion.description,
                        }}
                      />
                    </section>
                  </AccordionDetails>
                </Accordion>
              </div>
            ))}

          </section>
        </>
      ) : type === "FAQ" ? (
        faqData ? (
          <>
          <section {...props}>
            
            {/* <TabCustom className="mb-8" bold={true} value={title ? [title] :["سوالات متداول"]} type='accordion' /> */}
            <div className="mb-8 h-10 border-b">
              <div className="h-full w-fit border-b-theme border-b-2 px-2 text-theme text-sm">
                {/* <HelpIcon fontSize='small' /> */}
                {title ? title :"سوالات متداول"}
                
                </div>
            </div>
            <section className="grid gap-4">
            {faqData.map((faq, i) => {
              return (
                  <div
                    className="w-full h-fit relative flex justify-end last:mb-5"
                    key={faq.id}
                  >
                    {/* <div className="w-full h-16 bg-[#666] rounded-xl absolute right-3"></div> */}
                    <Accordion
                      expanded={i == expanded ? true : false}
                      onChange={() => handleChange(i)}
                      sx={{boxShadow:   i == 0 ? "0 -15px 0 0 var(--theme-color), 0 0 5px 2px #dddddda3" : "unset"}}
                    >
                      <AccordionSummary
                        aria-controls="panel3d-content"
                        id="panel3d-header"
                        sx={{
                          "& .MuiAccordionSummary-expandIconWrapper": {
                            color: "#000",
                          },
                        }}
                      >
                        <Typography sx={{fontWeight:500 , fontSize:16}}>{faq.question}</Typography>
                      </AccordionSummary>
                      <AccordionDetails>
                        <section
                          className="w-full ckeditor"
                          dangerouslySetInnerHTML={{ __html: faq.answer }}
                        />
                      </AccordionDetails>
                    </Accordion>
                  </div>
              );
            })}
            </section>
          </section>
          {dataStructure && 
            <script
              type="application/ld+json"
              dangerouslySetInnerHTML={{ __html: JSON.stringify(jsonLd) }}
            />
          }
          </>
        ) : (
          <></>
        )
      ) : null}
    </div>
  );
}
